package de.renew.splashscreen;

import java.beans.PropertyChangeEvent;
import java.net.URL;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.plugin.load.PluginLoaderComposition;


/**
 * The main class of the {@code SplashscreenPlugin}.
 *
 * @author Dominic Dibbern
 * @date Jan 23, 2012
 */
public class SplashscreenPlugin extends PluginAdapter implements ISplashscreenPlugin {
    private static final String KEY_SPLASHSCREEN_ENABLED = "de.renew.splashscreen.enabled";

    private RenewSplashScreen _renewSplashScreen;

    /**
     * Construct a new instance of the {@code SplashscreenPlugin}.
     * This constructor is called via reflection from
     * {@link de.renew.plugin.load.AbstractPluginLoader}
     *
     * @param propertyURL URL to the properties file
     * @throws PluginException if the instantiation failed.
     */
    public SplashscreenPlugin(URL propertyURL) throws PluginException {
        super(propertyURL);
        showScreen();
    }

    /**
     * Construct a new instance of the {@code SplashscreenPlugin}.
     * This constructor is called via reflection from
     * {@link de.renew.plugin.load.AbstractPluginLoader}
     *
     * @param props properties for this plugin
     */
    public SplashscreenPlugin(PluginProperties props) {
        super(props);
        showScreen();
    }

    private void showScreen() {
        if (getProperties().getBoolProperty(KEY_SPLASHSCREEN_ENABLED)) {
            _renewSplashScreen = RenewSplashScreen.getInstance();
            if (_renewSplashScreen != null) {
                _renewSplashScreen.showSplashScreen();
                PluginLoaderComposition.setSplashScreen(this);
            }
        } else {
            LOGGER.debug("Splash screen disabled by user choice.");
        }
    }


    @Override
    public boolean cleanup() {
        if (_renewSplashScreen != null) {
            closeSplashScreen();
        }
        PluginLoaderComposition.setSplashScreen(null);
        return super.cleanup();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        _renewSplashScreen.progressBarPropertyChange(evt);
    }

    @Override
    public void closeSplashScreen() {
        _renewSplashScreen.closeSplashScreen();
        _renewSplashScreen = null;
    }
}