
# Util

## User Guide

_Util_ provides basic classes that are used throughout Renew.

### Features

 - _Util_ provides a diverse set of features for example:
 - a FileFinder 
 - a Queue
 - a Customized implementation of a String

### Example Usage

_Util_ does not provide any functionality on its own. Instead, it provides classes/functionalities that can be used by other Plugins.
 
### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

_Util_ does not provide any commands.

### Installation

Install _Util_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Loader`: (mandated)
- `log4j`: Logging framework

### Configuration

During the initialization of _Util_, no properties are read from the `renew.properties` file in the Renew root directory.

## Developer Guide

### Core Classes

- `ClassSource`: is used during simulations to feature reloading of classes.

### How to Extend

_Util_ exposes multiple Interfaces,
- `de.renew.util.DelayedFieldOwner` - this interface has to be implemented by objects containing delayed written fields so they can be reassigned by a `RenewObjectInputStream`
- `de.renew.util.FileFindListener` - this interface needs to be implemented by classes that want to be notified when a file search has been finished
- `de.renew.util.OrderedLockable` - instances of this interface subject themselves to ordered locking
- `de.renew.util.TextToken` - must be implemented by classes which are also implementing `de.renew.remote.TextTokenAccessor` to allow the retrieval of its textual representation.

You can implement those interfaces to add additional functionality to _Util_.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- _Util_ does not feature a main class that extends PluginAdapter, like most Plugins, instead it uses a PluginManager and a ClassLoader.
- _Util_ is a collection of classes/functionalities that can be used by other Plugins. 

<!-- Contribution Info -->

<!-- License -->
