package de.renew.util;

/**
 * PathEntry provides a means to store OS-specific file system convention paths pointing towards ressources such as
 * nets. PathEntrys may be absolute, or considered relative against the Java classpath. In the latter case, they must
 * be resolved separately.
 *
 * @author Lawrence Cabac
 */
public class PathEntry {

    /**
     * A path to use when looking for nets. The path is stored using
     * OS-specific file system conventions.
     **/
    public final String path;

    /**
     * Indicates that the <code>path</code> component is considered to
     * be relative against the Java classpath. This means that this
     * <code>path</code> should not be looked up in the filesystem
     * directly, but used for a {@link ClassLoader#getResource} query.
     * The <code>CLASSPATH</code> keyword used in the String notation
     * of the net path has been removed from the path component.
     **/
    public final boolean isClasspathRelative;

    /**
     * Construct a new PathEntry using the provided path, and the boolean of whether is it relative against the java classpath
     * or can be resolved in the filesystem directly.
     * @param path The path under which to locate the ressource
     * @param isClasspathRelative must be set to true if the path submitted is relative against the Java classpath and
     *                            can't be looked up directly on the filesystem.
     * @author Lawrence Cabac
     */
    public PathEntry(String path, boolean isClasspathRelative) {
        this.path = path;
        this.isClasspathRelative = isClasspathRelative;
    }
}