package de.renew.util;

import java.io.IOException;
import java.io.ObjectInput;


/**
 * Internal class needed by {@link ClassSource}.
 *
 * @author Michael Duvigneau
 **/
public class ReloadableDeserializerImpl {
    /**
     * Turn a serialized ObjectInput object into an Object-type object.
     * @param input the ObjectInput from which to construct the Object
     * @return the read-in Object
     * @throws ClassNotFoundException if the Class of the Object cannot be found
     * @throws IOException if interactions with the underlying input stream fail
     */
    public Object readObject(ObjectInput input) throws ClassNotFoundException, IOException {
        return input.readObject();
    }
}