package de.renew.windowmanagement;

import de.renew.plugin.PluginManager;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.commands.DarkThemeCLCommand;

/**
 * initialising a workbench and provides it.
 */
public class WindowManagementPlugin extends DIPlugin {

    private final WorkbenchProxy _workbench;

    /**
     * The main start function for the WindowManagementPlugin class.
     *
     * @param args The arguments that will be parsed into the Plugin start.
     */
    public static void main(String[] args) {
        new WindowManagementPlugin();
    }

    /**
     * creates a new WorkbenchProxy and place it in the workbench variable.
     */
    @Inject
    public WindowManagementPlugin() {

        _workbench = new WorkbenchProxy();
    }

    /**
     * Return a Workbench object of the used workbench.
     *
     * @return the workbench from the WindowManagementPlugin.
     */
    @Provides
    public Workbench getWorkbench() {
        return _workbench;
    }

    @Override
    public void init() {
        CLCommand darkThemeClCommand = new DarkThemeCLCommand();
        PluginManager.getInstance().addCLCommand("darktheme", darkThemeClCommand);

    }
}
