package de.renew.windowmanagement.commands;

import java.awt.Color;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import javax.swing.UIManager;

import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;

/**
 * Change the color theme of the Nimbus look and feel to a dark blue variant.
 */
public class DarkThemeCLCommand implements CLCommand {
    @Override
    public void execute(String[] args, PrintStream response) {
        final String themeName = "Nimbus";

        UIManager.put("nimbusBase", new Color(0, 15, 33));
        UIManager.put("nimbusFocus", new Color(23, 43, 68));
        UIManager.put("control", new Color(58, 78, 98));
        UIManager.put("text", new Color(145, 158, 175));
        UIManager.put("info", new Color(23, 43, 68));
        UIManager.put("nimbusSelectionBackground", new Color(21, 35, 53));
        UIManager.put("nimbusLightBackground", new Color(23, 43, 68));

        LookAndFeelList list = LookAndFeelList.getDefaultList();
        if (themeName.equals(list.getLookAndFeel().getName())) {
            // Nimbus is the current look and feel
            // Update the theme
            for (int i = 0; i < list.size(); i++) {
                LookAndFeelList.Info info = list.get(i);
                if (themeName.equals(info.getName())) {
                    list.setLookAndFeel(info);
                    break;
                }
            }
        }

        // Execute any following commands
        if (args != null && args.length > 0) {
            String after = args[0];
            int length = args.length;
            String[] newArgs;

            if (length > 1) {
                newArgs = Arrays.copyOfRange(args, 1, length - 1);
            } else {
                // No further arguments, just execute the
                newArgs = new String[0];
            }
            Map<String, CLCommand> commands = PluginManager.getInstance().getCLCommands();

            CLCommand clCommand = commands.get(after);
            if (clCommand != null) {
                clCommand.execute(newArgs, response);
            }
        }
    }

    @Override
    public String getDescription() {
        return "Change the color theme of the Nimbus look and feel to a dark blue variant.";
    }

    @Override
    public String getArguments() {
        return null;
    }
}