/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.FigureSelection;
import de.renew.gui.CPNDrawing;
import de.renew.momoc.procedures.CTLModelChecker;
import de.renew.momoc.procedures.Procedure;
import de.renew.momocgui.commands.ParallelProcedureRunner;
import de.renew.momocgui.environment.EnvironmentFrame;
import de.renew.momocgui.util.NetUtils;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CTLModelCheckCommand {
    private static final Logger log = Logger.getLogger(CTLModelCheckCommand.class);

    public static void execute() {
        log.info((Object)"Starting CTL on selected drawing");
        new Thread(new ParallelProcedureRunner((Procedure)new CTLModelChecker(), (String[])EnvironmentFrame.getNetFormulas().stream().filter(p -> !p.equals("")).toArray(String[]::new))).start();
    }

    public static void executeSelected() {
        log.info((Object)"Starting CTL on selected textbox");
        Drawing d = DrawPlugin.getGui().drawing();
        if (d instanceof CPNDrawing) {
            FigureSelection f = DrawPlugin.getGui().view().getFigureSelection();
            HashSet<String> formulas = new HashSet<String>();
            for (Figure figure : f.getData()) {
                if (!(figure instanceof TextFigure)) continue;
                formulas.addAll(NetUtils.readFormulas((TextFigure)figure));
            }
            if (formulas.size() > 0) {
                new Thread(new ParallelProcedureRunner((Procedure)new CTLModelChecker(), (String[])formulas.stream().filter(p -> !p.equals("")).toArray(String[]::new))).start();
            }
        }
    }
}

