/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.environment;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class DescriptionTextArea
extends JTextArea {
    private final String _description;
    private final Font _defaultFont = new JLabel().getFont();
    private final Font _unfocusedFont = new Font(this._defaultFont.getName(), 2, this._defaultFont.getSize());

    DescriptionTextArea(String description) {
        this._description = description;
        this.setUnfocused();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DescriptionTextArea.this.setFocused();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DescriptionTextArea.this.setUnfocused();
            }
        });
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (text.equals(this._description)) {
            return "";
        }
        return text;
    }

    boolean hasText() {
        return !this.getText().equals("") && this.getText() != null;
    }

    private void setFocused() {
        if (!this.hasText()) {
            this.setText(null);
            this.setFont(this._defaultFont);
            this.setForeground(Color.BLACK);
        }
    }

    private void setUnfocused() {
        if (!this.hasText()) {
            this.setText(this._description);
            this.setFont(this._unfocusedFont);
            this.setForeground(Color.GRAY);
        }
    }
}

