/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.environment;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.momoc.procedures.Procedure;
import de.renew.momocgui.GUIConstants;
import de.renew.momocgui.environment.ProcedureAndResultManager;
import de.renew.momocgui.environment.ProcedureTableModel;
import de.renew.momocgui.environment.ProcedureWithResult;
import de.renew.momocgui.util.NetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class ProcedureListFrame {
    private static final Logger log = Logger.getLogger(ProcedureListFrame.class);
    private static ProcedureListFrame _instance;
    private static final String FRAME_NAME = "List of executed Procedures";
    private final JFrame _frame = new JFrame("List of executed Procedures");
    private final JPanel _container;
    private JButton _selectAll;
    private JButton _visualize;
    private JButton _cancel;
    private JButton _restart;
    private JButton _restartHere;
    private JButton _write;
    private JButton _delete;
    private JComboBox<String> _netList;
    private ArrayList<String> _shownNets;
    private JTable _jTable;
    private boolean _view = true;
    private String _netName;
    private final ArrayList<ProcedureWithResult> _selectedProcedures;

    private ProcedureListFrame() {
        this._frame.setLayout(new BoxLayout(this._frame.getContentPane(), 0));
        this._selectedProcedures = new ArrayList();
        this._container = new JPanel();
        this._container.setLayout(new BorderLayout());
        this._container.setPreferredSize(GUIConstants.SIZE_CONTAINER);
        JPanel procedurePanel = this.createProcedurePanel();
        JPanel buttonPanel = this.createButtonPanel();
        this._container.add((Component)buttonPanel, "North");
        this._container.add((Component)procedurePanel, "Center");
        this._frame.add(this._container);
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProcedureListFrame.this.closeFrame();
            }
        });
        this._frame.setMinimumSize(GUIConstants.SIZE_FRAME_MINIMUM);
        this._frame.setSize(GUIConstants.SIZE_FRAME_PREFERRED);
        this._frame.setResizable(true);
        this._frame.setVisible(true);
        ProcedureAndResultManager.getInstance().addPropertyChangeListener(o -> {
            Object source = o.getSource();
            if (source instanceof Procedure) {
                this.updateTable();
            } else if (source instanceof ProcedureWithResult) {
                this.updateTable();
                this.updateButtons();
            } else if (source instanceof ProcedureAndResultManager) {
                this.update();
            }
        });
    }

    private JPanel createButtonPanel() {
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.setPreferredSize(GUIConstants.SIZE_PANEL_DOUBLE);
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new FlowLayout());
        showPanel.setPreferredSize(GUIConstants.SIZE_PANEL_SINGLE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setPreferredSize(GUIConstants.SIZE_PANEL_SINGLE);
        JLabel showLabel = new JLabel("Show:");
        this.createNetList();
        showPanel.add(showLabel);
        showPanel.add(this._netList);
        this.createAllButtons();
        this.addAllButtons(buttonPanel);
        containerPanel.add(showPanel);
        containerPanel.add(buttonPanel);
        this.updateButtons();
        return containerPanel;
    }

    private void addAllButtons(JPanel buttonPanel) {
        buttonPanel.add(this._selectAll);
        buttonPanel.add(this._visualize);
        buttonPanel.add(this._cancel);
        buttonPanel.add(this._restart);
        buttonPanel.add(this._restartHere);
        buttonPanel.add(this._write);
        buttonPanel.add(this._delete);
    }

    private void createAllButtons() {
        this.createSelectAllButton();
        this.createVisualizeButton();
        this.createCancelButton();
        this.createRestartButton();
        this.createRestartHereButton();
        this.createWriteButton();
        this.createDeleteButton();
    }

    private void createDeleteButton() {
        this._delete = this.createButton("Delete");
        this._delete.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._delete.setToolTipText("Delete all selected procedures");
        this._delete.addActionListener(o -> {
            ProcedureAndResultManager.getInstance().remove(this._selectedProcedures);
            this._jTable.clearSelection();
        });
    }

    private void createWriteButton() {
        this._write = this.createButton("Write");
        this._write.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._write.setToolTipText("<html>Write all selected CTL Formulas to their corresponding nets.<br>This adds them to the first Momoc textbox found,<br>or creates a new one if none is present.</html>");
        this._write.addActionListener(o -> this.writeAllFormulasIntoNets());
    }

    private void writeAllFormulasIntoNets() {
        Map<Object, List<ProcedureWithResult>> procedureGroup = this._selectedProcedures.stream().collect(Collectors.groupingBy(ProcedureWithResult::getNetName));
        Iterator drawings = DrawPlugin.getGui().drawings().asIterator();
        while (drawings.hasNext()) {
            Drawing drawing = (Drawing)drawings.next();
            List<ProcedureWithResult> procedures = procedureGroup.get(drawing.getName());
            if (procedures == null) continue;
            TextFigure textFigure = this.findOrCreateFormulaTextFigure(drawing);
            this.addFormulas(textFigure, procedures);
            if (DrawPlugin.getGui().drawing().equals(drawing)) {
                DrawPlugin.getGui().doTextEdit(textFigure);
            }
            procedureGroup.remove(drawing.getName());
        }
        if (!procedureGroup.isEmpty()) {
            log.info((Object)"Could not write all procedures into their nets. Maybe some nets are not open?");
        }
    }

    private void addFormulas(TextFigure textFigure, List<ProcedureWithResult> procedures) {
        Set<String> formulas = procedures.stream().filter(ProcedureWithResult::usesFormulas).map(ProcedureWithResult::toString).collect(Collectors.toSet());
        NetUtils.writeFormulas(textFigure, formulas);
    }

    private TextFigure findOrCreateFormulaTextFigure(Drawing drawing) {
        Iterator figures = drawing.figures().asIterator();
        while (figures.hasNext()) {
            TextFigure textFigure;
            Figure figure = (Figure)figures.next();
            if (!(figure instanceof TextFigure) || !NetUtils.isMomocField(textFigure = (TextFigure)figure)) continue;
            return textFigure;
        }
        TextFigure newTextFigure = new TextFigure();
        drawing.add((Figure)newTextFigure);
        return newTextFigure;
    }

    private void createRestartHereButton() {
        this._restartHere = this.createButton("Restart Here");
        this._restartHere.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._restartHere.setToolTipText("<html>Restart all selected procedures.<br>The procedures rerun on the currently selected net.</html>");
        this._restartHere.addActionListener(o -> {
            for (ProcedureWithResult s : this._selectedProcedures) {
                s.restartHere();
            }
        });
    }

    private void createRestartButton() {
        this._restart = this.createButton("Restart");
        this._restart.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._restart.setToolTipText("<html>Restart all selected procedures.<br>The procedures rerun on their original net.</html>");
        this._restart.addActionListener(o -> {
            for (ProcedureWithResult s : this._selectedProcedures) {
                s.restart();
            }
        });
    }

    private void createCancelButton() {
        this._cancel = this.createButton("Cancel");
        this._cancel.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._cancel.setToolTipText("Stops all selected running procedures.");
        this._cancel.addActionListener(o -> {
            for (ProcedureWithResult s : this._selectedProcedures) {
                s.initiateAbort();
            }
            this.updateTable();
            this.updateButtons();
        });
    }

    private void createVisualizeButton() {
        this._visualize = this.createButton("Show Result");
        this._visualize.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._visualize.setToolTipText("Show the results of all selected procedures.");
        this._visualize.addActionListener(o -> {
            for (ProcedureWithResult s : this._selectedProcedures) {
                if (s.getStatus() != 1) continue;
                s.visualizeResult();
            }
        });
    }

    private void createSelectAllButton() {
        this._selectAll = this.createButton("Select All");
        this._selectAll.setPreferredSize(GUIConstants.SIZE_BUTTON);
        this._selectAll.setToolTipText("<html>Select all currently visible procedures.<br>Deselect when all procedures are already selected.</html>");
        this._selectAll.addActionListener(o -> {
            if (this._jTable.getSelectedRows().length == this._jTable.getRowCount()) {
                this._jTable.clearSelection();
            } else {
                this._jTable.selectAll();
            }
        });
    }

    private void createNetList() {
        this._netList = new JComboBox();
        this._netList.setToolTipText("Only show procedures that are run on the selected net.");
        this._netList.setPreferredSize(new Dimension(178, 25));
        this._netList.addItem("All");
        this._shownNets = new ArrayList();
        ProcedureAndResultManager.getInstance().addPropertyChangeListener(o -> {
            if (o.getSource() instanceof ProcedureAndResultManager) {
                ArrayList<String> registeredNets = this.usedNets();
                ArrayList<String> i = new ArrayList<String>();
                if (o.getPropertyName().equals("removed Procedures")) {
                    for (String net : this._shownNets) {
                        if (registeredNets.contains(net)) continue;
                        if (this._netList.getSelectedItem().equals(net)) {
                            this._netList.setSelectedIndex(0);
                        }
                        i.add(net);
                        this._netList.removeItem(net);
                    }
                    this._shownNets.removeAll(i);
                } else {
                    for (String net : registeredNets) {
                        if (this._shownNets.contains(net)) continue;
                        i.add(net);
                        this._netList.addItem(net);
                    }
                    this._shownNets.addAll(i);
                }
            }
        });
        this._netList.addActionListener(o -> {
            this._jTable.clearSelection();
            String selectedItem = this._netList.getSelectedItem().toString();
            if (selectedItem.equals("All")) {
                this._view = true;
            } else {
                this._view = false;
                this._netName = selectedItem;
            }
            this.update();
        });
    }

    private JButton createButton(String buttonName) {
        if (!GUIConstants.BUTTON_PATHS.containsKey(buttonName)) {
            return new JButton(buttonName);
        }
        String buttonPath = GUIConstants.BUTTON_PATHS.get(buttonName);
        try {
            ImageIcon icon = new ImageIcon(ImageIO.read(this.getClass().getResource(buttonPath)).getScaledInstance(GUIConstants.SIZE_BUTTON.width, GUIConstants.SIZE_BUTTON.height, 4));
            return new JButton(icon);
        }
        catch (IOException e) {
            return new JButton(buttonName);
        }
    }

    private void update() {
        this.updateTable();
        this.updateFilters();
        this.updateButtons();
    }

    private void updateTable() {
        this._jTable.revalidate();
        this._jTable.repaint();
    }

    private void updateButtons() {
        boolean bselectAll = false;
        boolean bvisualize = false;
        boolean bcancel = false;
        boolean brestart = false;
        boolean bwrite = false;
        boolean bdelete = false;
        if (this._selectedProcedures.size() > 0) {
            bselectAll = true;
            brestart = true;
            bdelete = true;
            for (ProcedureWithResult p : this._selectedProcedures) {
                if (p.getStatus() == 0) {
                    bcancel = true;
                }
                if (p.getStatus() == 1) {
                    bvisualize = true;
                }
                if (!p.usesFormulas()) continue;
                bwrite = true;
            }
        } else if (this._jTable.getRowCount() > 0) {
            bselectAll = true;
        }
        this._selectAll.setEnabled(bselectAll);
        this._visualize.setEnabled(bvisualize);
        this._cancel.setEnabled(bcancel);
        this._restart.setEnabled(brestart);
        this._restartHere.setEnabled(brestart);
        this._write.setEnabled(bwrite);
        this._delete.setEnabled(bdelete);
    }

    private void updateFilters() {
        ((TableRowSorter)this._jTable.getRowSorter()).setRowFilter(null);
        if (!this._view) {
            ((TableRowSorter)this._jTable.getRowSorter()).setRowFilter(RowFilter.regexFilter("^" + this._netName + "$", new int[0]));
        }
    }

    private ArrayList<String> usedNets() {
        ArrayList<String> nets = new ArrayList<String>();
        for (ProcedureWithResult p : ProcedureAndResultManager.getInstance().getRegisteredProcedures()) {
            if (nets.contains(p.getNetName())) continue;
            nets.add(p.getNetName());
        }
        return nets;
    }

    private JPanel createProcedurePanel() {
        JPanel procedurePanel = new JPanel();
        procedurePanel.setLayout(new BorderLayout());
        procedurePanel.setBorder(BorderFactory.createTitledBorder("last Procedures"));
        JScrollPane scrollPane = new JScrollPane(this.createProcedureList());
        procedurePanel.add(scrollPane);
        return procedurePanel;
    }

    private JTable createProcedureList() {
        this._jTable = new JTable(new ProcedureTableModel());
        this._jTable.setAutoResizeMode(4);
        this._jTable.setRowSelectionAllowed(true);
        this._jTable.getSelectionModel().addListSelectionListener(new ProcedureListSelectionHandler());
        this._jTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._jTable.getModel());
        this._jTable.setRowSorter(sorter);
        this._jTable.getColumnModel().getColumn(2).setCellRenderer(new ResultColumnCellRenderer());
        return this._jTable;
    }

    public static void show() {
        if (_instance == null) {
            _instance = new ProcedureListFrame();
        } else {
            ProcedureListFrame._instance._frame.setVisible(true);
        }
    }

    public static synchronized void close() {
        if (_instance != null) {
            ProcedureListFrame._instance._frame.setVisible(false);
            for (ProcedureWithResult p : ProcedureAndResultManager.getInstance().getRegisteredProcedures()) {
                p.initiateAbort();
            }
            ProcedureListFrame._instance._frame.dispose();
        }
    }

    private synchronized void closeFrame() {
        if (this._frame != null) {
            this._frame.setVisible(false);
        }
    }

    class ProcedureListSelectionHandler
    implements ListSelectionListener {
        ProcedureListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] indices;
            ProcedureListFrame.this._selectedProcedures.clear();
            for (int index : indices = ProcedureListFrame.this._jTable.getSelectedRows()) {
                int i = ProcedureListFrame.this._jTable.convertRowIndexToModel(index);
                ProcedureListFrame.this._selectedProcedures.add(ProcedureAndResultManager.getInstance().getRegisteredProcedures().get(i));
            }
            ProcedureListFrame.this.updateButtons();
        }
    }

    class ResultColumnCellRenderer
    extends DefaultTableCellRenderer {
        ResultColumnCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            row = ProcedureListFrame.this._jTable.convertRowIndexToModel(row);
            ProcedureTableModel tableModel = (ProcedureTableModel)table.getModel();
            if (tableModel.getValueAt(row, col).equals("TRUE")) {
                label.setBackground(Color.GREEN);
            } else if (tableModel.getValueAt(row, col).equals("FALSE")) {
                label.setBackground(Color.RED);
            } else {
                label.setBackground(null);
            }
            return label;
        }
    }
}

