/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.environment;

import de.renew.momoc.core.Result;
import de.renew.momoc.procedures.Procedure;
import de.renew.momocgui.commands.ParallelProcedureRunner;
import de.renew.momocgui.environment.GUIAborter;
import de.renew.momocgui.resultVisualization.ResultVisualizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ProcedureWithResult {
    private final String _name;
    private final String _netName;
    private final Procedure _procedure;
    private final GUIAborter _aborter;
    private Result _result = null;
    private int _status;
    private final PropertyChangeSupport _support;
    private Object _progress = "Started";
    public static final int RUNNING = 0;
    public static final int FINISHED = 1;
    public static final int CANCELED = 2;

    public ProcedureWithResult(String nameOfProcedure, String nameOfNet, Procedure procedure, GUIAborter aborter) {
        this._name = nameOfProcedure;
        this._netName = nameOfNet;
        this._procedure = procedure;
        this._aborter = aborter;
        this._status = 0;
        this._support = new PropertyChangeSupport(this);
        procedure.addProgressListener(o -> {
            this._progress = o.getNewValue();
            this._support.firePropertyChange(o);
        });
    }

    public String toString() {
        return this._name;
    }

    public boolean usesFormulas() {
        return this._procedure.usesFormulas();
    }

    public void restart() {
        String[] formula = new String[]{this._name};
        new Thread(new ParallelProcedureRunner(this._procedure, this._netName, formula)).start();
    }

    public void restartHere() {
        String[] formula = new String[]{this._name};
        new Thread(new ParallelProcedureRunner(this._procedure, formula)).start();
    }

    public void setResult(Result newResult) {
        if (newResult == null) {
            this._progress = "Started";
            this._status = 0;
        } else {
            this._status = 1;
        }
        this._support.firePropertyChange("result", this._result, newResult);
        this._result = newResult;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public int getStatus() {
        return this._status;
    }

    public String getNetName() {
        return this._netName;
    }

    public String getShowableResult() {
        if (this._result == null) {
            if (this._status == 2) {
                return "canceled";
            }
            if (this._status == 0) {
                return this._progress.toString();
            }
        } else if (this._result.getFulfillsSpecification() != null) {
            return this._result.getFulfillsSpecification().toString().toUpperCase();
        }
        return "finished";
    }

    public GUIAborter getAborter() {
        return this._aborter;
    }

    public void visualizeResult() {
        new ResultVisualizer(this._result, this._aborter);
    }

    public void initiateAbort() {
        if (this._status == 0) {
            this._aborter.initiateAbort();
            this._status = 2;
        }
    }
}

