/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.resultVisualization;

import de.renew.momoc.parser.nodes.NodeManager;
import de.renew.momoc.parser.nodes.RegisteredNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class FormulaTreeVisualizer
extends JPanel {
    private final JTree _tree;
    private final Map<DefaultMutableTreeNode, Short> _treeMap = new HashMap<DefaultMutableTreeNode, Short>();

    FormulaTreeVisualizer(NodeManager nodeManager, Short rootNode) {
        this._tree = this.registeredTreeToJTree(rootNode, nodeManager);
        JScrollPane treeView = new JScrollPane(this._tree);
        FontMetrics fm = treeView.getFontMetrics(treeView.getFont());
        int textWidth = fm.stringWidth(nodeManager.getNode(rootNode).getNode().toString());
        int maxWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth() / 2;
        treeView.setPreferredSize(new Dimension(Math.min(maxWidth, textWidth + 10), 170));
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setLeafIcon(null);
        this._tree.setCellRenderer(renderer);
        this._tree.getSelectionModel().setSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.add((Component)treeView, "Center");
    }

    void registerTreeSelectionListener(TreeSelectionListener selectionListener) {
        this._tree.addTreeSelectionListener(selectionListener);
    }

    private JTree registeredTreeToJTree(Short encodedRootNode, NodeManager nodeManager) {
        DefaultMutableTreeNode top = this.registeredNodeToJTreeNode(encodedRootNode, nodeManager);
        return new JTree(top);
    }

    private DefaultMutableTreeNode registeredNodeToJTreeNode(Short encodedNode, NodeManager nodeManager) {
        RegisteredNode registeredNode = nodeManager.getNode(encodedNode);
        DefaultMutableTreeNode jTreeNode = new DefaultMutableTreeNode(registeredNode.getNode().toString());
        Iterator children = registeredNode.getAllChildren().iterator();
        if (registeredNode.getNode().toString().equals("Dont_Visualize")) {
            jTreeNode = this.registeredNodeToJTreeNode((Short)children.next(), nodeManager);
        }
        while (children.hasNext()) {
            jTreeNode.add(this.registeredNodeToJTreeNode((Short)children.next(), nodeManager));
        }
        this._treeMap.put(jTreeNode, encodedNode);
        return jTreeNode;
    }

    Short getSelectedNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        return this._treeMap.get(node);
    }
}

