/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.resultVisualization;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.momoc.core.Result;
import de.renew.momoc.parser.nodes.NodeManager;
import de.renew.momocgui.resultVisualization.ColorizableGraphDrawing;
import de.renew.momocgui.resultVisualization.FormulaTreeVisualizer;
import de.renew.momocgui.resultVisualization.GraphDrawingFactory;
import de.renew.momocgui.resultVisualization.WitnessReplayVisualizer;
import de.renew.rgbase.gui.Aborter;
import de.renew.rgbase.gui.GraphDrawing;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ResultVisualizer
extends JFrame {
    private static final Logger log = Logger.getLogger(ResultVisualizer.class);
    private static final String NOT = "\u00ac";
    private static final String AND = "\u2227";
    private static final String OR = "\u2228";
    private final Result _result;
    private GraphDrawing _reachabilityGraphDrawing;
    FormulaTreeVisualizer _formulaTreeVisualizer;
    private static final int RG_WARNING_SIZE = 1000;

    public ResultVisualizer(Result result, Aborter aborter) {
        this._result = result;
        if (this._result != null) {
            if (result.isReachabilityGraphOnly()) {
                this.drawRG(aborter, true);
            } else {
                this.displayResult();
            }
        } else {
            log.error((Object)"Procedure did not finish correctly. Nothing to show");
        }
    }

    private void displayResult() {
        this.setTitle("Result");
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (this._result.getNodeManager() != null) {
            this._formulaTreeVisualizer = new FormulaTreeVisualizer(this._result.getNodeManager(), this._result.getRootNode());
            if (this._result.getSelectionListener() == null) {
                this._formulaTreeVisualizer.registerTreeSelectionListener(e -> {
                    if (this._reachabilityGraphDrawing instanceof ColorizableGraphDrawing) {
                        ((ColorizableGraphDrawing)this._reachabilityGraphDrawing).recolorByFormula(this._formulaTreeVisualizer.getSelectedNode());
                    }
                });
            } else {
                this._formulaTreeVisualizer.registerTreeSelectionListener(this._result.getSelectionListener());
            }
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)this._formulaTreeVisualizer, c);
        }
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new GridBagLayout());
        LinkedHashMap<String, JLabel> labels = new LinkedHashMap<String, JLabel>();
        JTextField formulaLabel = null;
        if (this._result.getSpecification() != null) {
            formulaLabel = this.createCopyableLabel(this.replaceLogicSymbols(this._result.getSpecification()));
        }
        if (this._result.getFulfillsSpecification() != null) {
            JLabel resultLabel = this.createLabel(this._result.getFulfillsSpecification().toString().toUpperCase());
            labels.put("Result:", resultLabel);
        }
        if (this._result.getReachabilityGraph() != null) {
            labels.put("Root Net:", this.createLabel(this._result.getReachabilityGraph().getStartNode().getRootNetInstance().toString()));
        }
        Map additionalResults = this._result.getAdditionalResults();
        for (Object name : additionalResults.keySet()) {
            labels.put((String)name, this.createLabel((String)additionalResults.get(name)));
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        if (formulaLabel != null) {
            c.insets = new Insets(3, 0, 3, 0);
            c.gridx = 0;
            c.gridy = 0;
            resultPanel.add((Component)new JLabel("Specification"), c);
            c.gridx = 1;
            resultPanel.add((Component)formulaLabel, c);
        }
        int i = 1;
        for (String label : labels.keySet()) {
            c.insets = new Insets(3, 0, 3, 0);
            c.gridx = 0;
            c.gridy = i++;
            resultPanel.add((Component)new JLabel(label), c);
            c.gridx = 1;
            resultPanel.add((Component)labels.get(label), c);
        }
        resultPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton rgDrawer = new JButton("Show Reachability Graph");
        if (this._result.getReachabilityGraph() != null) {
            rgDrawer.addActionListener(e -> this.openRGChecked());
        } else {
            rgDrawer.setEnabled(false);
        }
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = i;
        c.gridwidth = 2;
        resultPanel.add((Component)rgDrawer, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)resultPanel, c);
        this.pack();
        this.setVisible(true);
    }

    private String replaceLogicSymbols(String formula) {
        return formula.replace("NOT", NOT).replace("Not", NOT).replace("OR", OR).replace("Or", OR).replace("AND", AND).replace("And", AND);
    }

    private void openRGChecked() {
        Object[] options = new String[]{"Yes", "Yes, without edge labels", "No"};
        int size = this._result.getReachabilityGraph().getNodes().size();
        if (this._reachabilityGraphDrawing == null && size > 1000) {
            int n = JOptionPane.showOptionDialog(null, "Warning: The Reachability Graph has " + size + " nodes.\nVisualisation may take some time. Proceed?", "Reachability Graph Size Warning", -1, 2, null, options, options[0]);
            if (n == 0) {
                this.drawRG();
            } else if (n == 1) {
                this.drawRG(false);
            }
        } else {
            this.drawRG();
        }
    }

    private void showWitnessPath() {
        Short selectedNode = this._formulaTreeVisualizer.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = this._result.getRootNode();
        }
        WitnessReplayVisualizer witnessReplayVisualizer = new WitnessReplayVisualizer(this._result.getReachabilityGraph(), selectedNode);
        witnessReplayVisualizer.showFrame();
    }

    private JTextField createCopyableLabel(String text) {
        JTextField textPane = new JTextField(text);
        textPane.setEditable(false);
        textPane.setBackground(null);
        textPane.setBorder(null);
        return textPane;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        if (text.toUpperCase().equals("TRUE")) {
            label.setBackground(Color.GREEN);
            label.setOpaque(true);
        } else if (text.toUpperCase().equals("FALSE")) {
            label.setBackground(Color.RED);
            label.setOpaque(true);
        }
        return label;
    }

    private void drawRG() {
        this.drawRG(() -> false, true);
    }

    private void drawRG(boolean inscribeEdges) {
        this.drawRG(() -> false, inscribeEdges);
    }

    private void drawRG(Aborter aborter, boolean inscribeEdges) {
        if (this._reachabilityGraphDrawing != null) {
            if (DrawPlugin.getGui().getView((Drawing)this._reachabilityGraphDrawing) == null) {
                DrawPlugin.getGui().openDrawing((Drawing)this._reachabilityGraphDrawing);
            }
        } else {
            NodeManager nodeManager = this._result.getNodeManager();
            if (nodeManager != null) {
                Short selectedNode = this._formulaTreeVisualizer.getSelectedNode();
                if (selectedNode == null) {
                    selectedNode = this._result.getRootNode();
                }
                this._reachabilityGraphDrawing = GraphDrawingFactory.colorizable(aborter, this._result.getReachabilityGraph(), this._result.getInscMode(), this._result.getRootNode(), inscribeEdges);
                DrawPlugin.getGui().openDrawing((Drawing)this._reachabilityGraphDrawing);
            } else {
                this._reachabilityGraphDrawing = GraphDrawingFactory.uncolorizable(aborter, this._result.getReachabilityGraph(), this._result.getInscMode(), inscribeEdges);
                DrawPlugin.getGui().openDrawing((Drawing)this._reachabilityGraphDrawing);
            }
        }
    }
}

