/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.shadowcompiler.DefaultShadowNetLoader;
import de.renew.simulator.api.IFinderRegistration;
import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.loading.PathlessFinder;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class FinderRegistrationImpl
implements IFinderRegistration {
    private final Set<Finder> _registeredFinders = Collections.synchronizedSet(new HashSet());
    private final Set<PathlessFinder> _registeredPathlessFinders = new HashSet<PathlessFinder>();
    private DefaultShadowNetLoader _currentShadowNetLoader;

    FinderRegistrationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultNetFinder(Finder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredFinders.add(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.registerFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultNetFinder(Finder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredFinders.remove(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.removeFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultPathlessFinder(PathlessFinder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredPathlessFinders.add(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.registerPathlessFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultPathlessFinder(PathlessFinder finder) {
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredPathlessFinders.remove(finder);
            if (this._currentShadowNetLoader != null) {
                this._currentShadowNetLoader.removePathlessFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetLoader(ShadowNetLoader netLoader) {
        if (netLoader == null) {
            this._currentShadowNetLoader = null;
            return;
        }
        if (!(netLoader instanceof DefaultShadowNetLoader)) {
            throw new IllegalArgumentException("A DefaultShadowNetLoader was expected!");
        }
        this._currentShadowNetLoader = (DefaultShadowNetLoader)netLoader;
        Set<Finder> set = this._registeredFinders;
        synchronized (set) {
            this._registeredFinders.forEach(this._currentShadowNetLoader::registerFinder);
            this._registeredPathlessFinders.forEach(this._currentShadowNetLoader::registerPathlessFinder);
        }
    }

    public ShadowNetLoader getNetLoader() {
        return this._currentShadowNetLoader;
    }
}

