/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.ChannelBinder;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.ISearcher;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.unify.CalculationChecker;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Variable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Searcher
implements ISearcher {
    private static final Logger LOGGER = Logger.getLogger(Searcher.class);
    private Finder _finder;
    private final Set<Binder> _binders;
    private final Set<Occurrence> _occurrences;
    private Triggerable _primaryTriggerable;
    private double _earliestTime;
    private final ICalculationChecker _calcChecker;
    private final IStateRecorder _stateRecorder;
    private final Map<String, DeltaSet> _deltaSets;

    public Searcher() {
        this(new HashSet<Occurrence>(), new HashMap<String, DeltaSet>());
    }

    protected Searcher(Triggerable primaryTriggerable, Finder finder) {
        this();
        this._primaryTriggerable = primaryTriggerable;
        this._finder = finder;
    }

    protected Searcher(Searcher parent, Finder finder) {
        this(parent._occurrences, parent._deltaSets);
        this._primaryTriggerable = parent._primaryTriggerable;
        this._finder = finder;
    }

    private Searcher(Set<Occurrence> occurrences, Map<String, DeltaSet> deltaSets) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._binders = new HashSet<Binder>();
        this._occurrences = occurrences;
        this._calcChecker = new CalculationChecker();
        this._stateRecorder = new StateRecorder();
        this._deltaSets = deltaSets;
    }

    @Override
    public ICalculationChecker getCalculationChecker() {
        return this._calcChecker;
    }

    @Override
    public IStateRecorder getStateRecorder() {
        return this._stateRecorder;
    }

    @Override
    public boolean isCompleted() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._finder.isCompleted();
    }

    private void setPrimaryTriggerable(Triggerable triggerable) {
        if (triggerable != null) {
            triggerable.triggers().clear();
        }
        this._primaryTriggerable = triggerable;
    }

    protected Triggerable getPrimaryTriggerable() {
        return this._primaryTriggerable;
    }

    @Override
    public void insertTriggerable(TriggerableCollection triggerables) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._primaryTriggerable != null) {
            triggerables.include(this._primaryTriggerable);
        }
    }

    @Override
    public void addOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._occurrences.add(occurrence);
    }

    @Override
    public void removeOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._occurrences.remove(occurrence);
    }

    @Override
    public Collection<Occurrence> getOccurrences() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._occurrences;
    }

    @Override
    public DeltaSet getDeltaSet(DeltaSetFactory factory) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        String category = factory.getCategory();
        DeltaSet result = this._deltaSets.get(category);
        if (result == null) {
            result = factory.createDeltaSet();
            this._deltaSets.put(category, result);
        }
        return result;
    }

    @Override
    public double getEarliestTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._earliestTime;
    }

    private void setEarliestTime(double time) {
        this._earliestTime = time;
    }

    private Binder selectBestBinder() {
        Binder bestBinder = null;
        int bestBadness = 10000;
        Iterator<Binder> iterator = this._binders.iterator();
        while (iterator.hasNext() && !this.isCompleted()) {
            Binder binder = iterator.next();
            int badness = binder.bindingBadness(this);
            if (badness >= bestBadness) continue;
            bestBinder = binder;
            bestBadness = badness;
        }
        return bestBinder;
    }

    @Override
    public void search() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int checkpoint = this._stateRecorder.checkpoint();
        if (!this._binders.isEmpty()) {
            Binder binder = this.selectBestBinder();
            if (binder != null && !this.isCompleted()) {
                this.removeBinder(binder);
                binder.bind(this);
                this.addBinder(binder);
            }
        } else if (this._calcChecker.isConsistent()) {
            double time = 0.0;
            for (DeltaSet deltaSet : this._deltaSets.values()) {
                time = Math.max(time, deltaSet.computeEarliestTime());
            }
            this.setEarliestTime(time);
            this._finder.found(this);
        }
        this._stateRecorder.restore(checkpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int checkpoint = this._stateRecorder.checkpoint();
        try {
            Collection<Binder> binders = occurrence.makeBinders(this);
            this.addOccurrence(occurrence);
            this.addBinders(binders);
            this.search();
            this.removeBinders(binders);
            this.removeOccurrence(occurrence);
        }
        catch (Impossible e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this._stateRecorder.restore(checkpoint);
        }
    }

    @Override
    public void addBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._binders.add(binder);
    }

    @Override
    public void removeBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._binders.remove(binder);
    }

    @Override
    public void addBinders(Collection<Binder> binders) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._binders.addAll(binders);
    }

    @Override
    public void removeBinders(Collection<Binder> binders) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._binders.removeAll(binders);
    }

    private void startSearch() {
        this._stateRecorder.restore();
        if (!this._occurrences.isEmpty() || !this._binders.isEmpty()) {
            throw new RuntimeException("Searcher was not in idle state at the start of a search.");
        }
    }

    @Override
    public void searchAndRecover(Finder finder, Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this._finder = finder;
        this.setPrimaryTriggerable(triggerable);
        this._earliestTime = 0.0;
        try {
            searchable.startSearch(this);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        this._binders.clear();
        this._occurrences.clear();
        this._calcChecker.reset();
        this._stateRecorder.restore();
        this._deltaSets.clear();
        this.setPrimaryTriggerable(null);
        this._finder = null;
    }

    @Override
    public void initiatedSearch(ChannelTarget channelTarget, String name, Variable params, boolean isOptional, Finder finder, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this._finder = finder;
        this.setPrimaryTriggerable(triggerable);
        try {
            Variable targetVariable = new Variable(channelTarget, this._stateRecorder);
            ChannelBinder initialBinder = new ChannelBinder(targetVariable, name, params, isOptional);
            this.addBinder(initialBinder);
            this.search();
            this.removeBinder(initialBinder);
            this._stateRecorder.restore();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        this._binders.clear();
        this._occurrences.clear();
        this._calcChecker.reset();
        this._stateRecorder.restore();
        this._deltaSets.clear();
        this.setPrimaryTriggerable(null);
        this._finder = null;
    }
}

