/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.Types;

public abstract class AggregateExpression
implements Expression {
    private static final long serialVersionUID = -4094960769944117557L;
    private final Expression[] _expressions;
    private boolean _invertible = true;

    public AggregateExpression(Expression[] expressions) {
        this._expressions = expressions;
        this._invertible = false;
        for (int i = 0; i < expressions.length; ++i) {
            this._invertible = this._invertible || expressions[i].isInvertible();
        }
    }

    @Override
    public boolean isInvertible() {
        return this._invertible;
    }

    public Expression[] getExpressions() {
        return this._expressions;
    }

    @Override
    public abstract Class<?> getType();

    protected Object[] makeArray(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker, boolean forEvaluation) throws Impossible {
        int n = this._expressions.length;
        Variable[] vars = new Variable[n];
        for (int i = 0; i < n; ++i) {
            Expression expr = this._expressions[i];
            vars[i] = forEvaluation ? new Variable(expr.startEvaluation(mapper, recorder, checker), recorder) : new Variable(expr.registerCalculation(mapper, recorder, checker), recorder);
        }
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = vars[i].getValue();
        }
        return result;
    }

    protected abstract Object makeResultAggregate(Object[] var1, IStateRecorder var2) throws Impossible;

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        return this.makeResultAggregate(this.makeArray(mapper, recorder, checker, true), recorder);
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        return this.makeResultAggregate(this.makeArray(mapper, recorder, checker, false), recorder);
    }

    public String toString() {
        String result = "AggregateExpr(" + Types.typeToString(this.getType()) + ": ";
        for (int i = 0; i < this._expressions.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + String.valueOf(this._expressions[i]);
        }
        result = result + ")";
        return result;
    }
}

