/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.NetInstantiationException;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.INetInstantiator;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import java.io.Serializable;

public class NetInstantiator
implements INetInstantiator,
Serializable {
    private final Net _net;

    public NetInstantiator(Net net) {
        this._net = net;
    }

    protected Net getNet() {
        return this._net;
    }

    @Override
    public NetInstance makeInstance() throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new NetInstanceImpl(this._net);
    }

    @Override
    public NetInstance buildInstance(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            NetInstance instance = this.makeInstance();
            instance.createConfirmation(stepIdentifier);
            return instance;
        }
        catch (Impossible e) {
            RuntimeException re = new RuntimeException("Could not make instance of net " + this._net.getName() + ".", e);
            SimulatorEventLogger.log(stepIdentifier, new NetInstantiationException(this._net, e));
            throw re;
        }
    }

    @Override
    public NetInstance buildInstance() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.buildInstance(SimulationManager.getCurrentSimulator().currentStepIdentifier());
    }
}

