/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.transition.ManualInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Transition
implements Serializable,
TransitionEventProducer {
    private static final long serialVersionUID = -7955261691016471176L;
    private final NetElementID _id;
    private final String _name;
    private String _comment;
    private boolean _trace;
    private UplinkInscription _uplink;
    private final Set<TransitionInscription> _inscriptions;
    private transient TransitionEventListenerSet _listeners = new TransitionEventListenerSet();

    public Transition(Net net, String name, NetElementID id) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._id = id;
        this._name = name;
        this._trace = true;
        this._uplink = null;
        this._inscriptions = new HashSet<TransitionInscription>();
        net.add(this);
    }

    public NetElementID getID() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public boolean isSpontaneous() {
        return this._uplink == null && !this._inscriptions.contains(ManualInscription.getInstance());
    }

    public boolean listensToChannel(String channel) {
        return this._uplink != null && this._uplink.getName().equals(channel);
    }

    private void checkUplink() {
        this._uplink = null;
        for (TransitionInscription inscription : this._inscriptions) {
            if (!(inscription instanceof UplinkInscription)) continue;
            this._uplink = (UplinkInscription)inscription;
        }
    }

    public void add(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this._inscriptions.contains(transitionInscription)) {
            this._inscriptions.add(transitionInscription);
            this.checkUplink();
        }
    }

    public void remove(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._inscriptions.contains(transitionInscription)) {
            this._inscriptions.remove(transitionInscription);
            this.checkUplink();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this._listeners = new TransitionEventListenerSet();
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener listener) {
        this._listeners.addTransitionEventListener(listener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener listener) {
        this._listeners.removeTransitionEventListener(listener);
    }

    TransitionEventListenerSet getListenerSet() {
        return this._listeners;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public String getComment() {
        return this._comment;
    }

    public Set<TransitionInscription> inscriptions() {
        return this._inscriptions;
    }

    public static boolean isManual(Transition transition) {
        return transition._inscriptions.contains(ManualInscription.getInstance());
    }

    public UplinkInscription getUplink() {
        return this._uplink;
    }

    Set<TransitionInscription> getInscriptions() {
        return this._inscriptions;
    }
}

