/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.loading.NetLoader;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import java.util.Objects;

public class DefaultCompiledNetLoader
implements NetLoader {
    private final ISimulationManager _simulationManager;
    private final INetLookup _netLookup;
    private final ShadowNetLoader _netLoader;

    public DefaultCompiledNetLoader(ISimulationManager simulationManager, INetLookup netLookup, ShadowNetLoader netLoader) {
        this._simulationManager = Objects.requireNonNull(simulationManager, "Missing ISimulationManager");
        this._netLookup = Objects.requireNonNull(netLookup, "Missing INetLookup.");
        this._netLoader = Objects.requireNonNull(netLoader, "Missing ShadowNetLoader.");
    }

    @Override
    public Net loadNet(String netName) throws NetNotFoundException {
        try {
            ShadowNetSystem netSystem = this._netLoader.loadShadowNetSystem(netName);
            this._simulationManager.addShadowNetSystem(netSystem);
            Net net = this._netLookup.findForName(netName);
            if (net != null) {
                return net;
            }
        }
        catch (NetNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetNotFoundException(netName, (Throwable)e);
        }
        throw new NetNotFoundException(netName);
    }
}

