/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console.completer;

import de.renew.console.CHDependencyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.log4j.Logger;

public class DrawingsCompleter
implements Completer {
    private static final Logger LOGGER = Logger.getLogger(DrawingsCompleter.class);
    private final NullCompleter _nullCompleter = new NullCompleter();

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        List<String> drawingNames = DrawingsCompleter.getDrawingNames();
        if (CHDependencyListener.getChPlugin() != null && !drawingNames.isEmpty()) {
            return new StringsCompleter(drawingNames).complete(buffer, cursor, candidates);
        }
        return this._nullCompleter.complete(buffer, cursor, candidates);
    }

    private static List<String> getDrawingNames() {
        ArrayList<String> drawingNames = new ArrayList<String>();
        try {
            Class<?> drawPluginClass = CHDependencyListener.getChPlugin().getClass();
            Method getGuiMethod = drawPluginClass.getMethod("getGui", new Class[0]);
            Object gui = getGuiMethod.invoke((Object)CHDependencyListener.getChPlugin(), new Object[0]);
            if (gui != null) {
                Method drawingsMethod = gui.getClass().getMethod("drawings", new Class[0]);
                Enumeration drawings = (Enumeration)drawingsMethod.invoke(gui, new Object[0]);
                while (drawings.hasMoreElements()) {
                    Object drawing = drawings.nextElement();
                    Method getNameMethod = drawing.getClass().getMethod("getName", new Class[0]);
                    String name = (String)getNameMethod.invoke(drawing, new Object[0]);
                    drawingNames.add(name);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.debug((Object)"Could not get the list of drawing names, although the CH plugin should be available.", (Throwable)e);
        }
        return drawingNames;
    }
}

