/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rgbase.elements;

import de.renew.net.NetInstance;
import de.renew.rgbase.elements.Edge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = 9208206770140563018L;
    protected transient Collection<Edge> _edges;
    transient Set<Node> _predecessors;
    private ArrayList<Short> _labels;

    public Collection<Edge> getEdges() {
        if (this._edges == null) {
            return Collections.emptySet();
        }
        return this._edges;
    }

    public void addEdge(Edge edge) {
        if (this._edges == null) {
            this._edges = new HashSet<Edge>();
        }
        this._edges.add(edge);
    }

    public Set<Node> getPredecessors() {
        if (this._predecessors == null) {
            return Collections.emptySet();
        }
        return this._predecessors;
    }

    public void addPredecessor(Node node) {
        if (this._predecessors == null) {
            this._predecessors = new HashSet<Node>();
        }
        this._predecessors.add(node);
    }

    public abstract Collection<? extends NetInstance> getNetInstances();

    public abstract NetInstance getRootNetInstance();

    public abstract long getDepth();

    public void addLabel(Short label) {
        if (this._labels == null) {
            this._labels = new ArrayList();
        }
        this._labels.add(label);
    }

    public boolean hasLabel(Short label) {
        if (this._labels == null) {
            return false;
        }
        return this._labels.contains(label);
    }

    public void resetLabels() {
        this._labels = null;
    }
}

