/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceNodeFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionNodeFigure;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.ShadowNode;

public class ArcConnection
extends LineConnection
implements InscribableFigure {
    private static final long serialVersionUID = -7959501008698525009L;
    public static final ArcConnection NormalArc = new ArcConnection(1);
    public static final ArcConnection TestArc = new ArcConnection(0);
    public static final ArcConnection ReserveArc = new ArcConnection(2);
    private final int arcConnectionSerializedDataVersion = 1;
    private transient ShadowArc shadow = null;

    public ArcConnection() {
    }

    public ArcConnection(int arcType) {
        ArrowTip start = null;
        ArrowTip end = null;
        if (arcType == 2) {
            start = new ArrowTip();
        }
        if (arcType != 0) {
            end = new ArrowTip();
        }
        this.setStartDecoration((LineDecoration)start);
        this.setEndDecoration((LineDecoration)end);
    }

    public int getArcType() {
        int arrowMode = (Integer)this.getAttribute("ArrowMode");
        if (arrowMode == 0) {
            return 0;
        }
        if (arrowMode == 3) {
            return 2;
        }
        return 1;
    }

    public boolean canConnect(Figure start, Figure end) {
        return start instanceof TransitionNodeFigure && end instanceof PlaceNodeFigure || start instanceof PlaceNodeFigure && end instanceof TransitionNodeFigure;
    }

    public boolean canConnectStart(Figure start) {
        if (this.endFigure() != null) {
            return this.canConnect(start, this.endFigure());
        }
        return start instanceof TransitionNodeFigure || start instanceof PlaceNodeFigure;
    }

    public boolean canConnectEnd(Figure end) {
        if (this.startFigure() != null) {
            return this.canConnect(this.startFigure(), end);
        }
        return end instanceof TransitionNodeFigure || end instanceof PlaceNodeFigure;
    }

    public boolean getTraceMode() {
        Object value = this.getAttribute("TraceMode");
        if (value instanceof Boolean) {
            Boolean result = (Boolean)value;
            return result;
        }
        return true;
    }

    public void setAttribute(String name, Object value) {
        if (!name.equals("ArrowTip")) {
            super.setAttribute(name, value);
        }
    }

    public void release() {
        super.release();
        if (this.shadow != null) {
            this.shadow.discard();
        }
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        this.shadow = new ShadowArc(this.startShadow(), this.endShadow(), this.getArcType());
        this.shadow.setContext((Object)this);
        this.shadow.setID(this.getID());
        this.shadow.setTrace(this.getTraceMode());
        return this.shadow;
    }

    public boolean isReverse() {
        return (Integer)this.getAttribute("ArrowMode") == 1;
    }

    private ShadowNode anyShadow(boolean end) {
        ShadowHolder holder = (ShadowHolder)(end ? this.endFigure() : this.startFigure());
        return (ShadowNode)holder.getShadow();
    }

    ShadowNode startShadow() {
        return this.anyShadow(this.isReverse());
    }

    ShadowNode endShadow() {
        return this.anyShadow(!this.isReverse());
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.shadow;
    }
}

