/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.ErrorApi;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.ErrorState;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointHitEvent;
import de.renew.gui.BreakpointHitListener;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ClearAllBreakpointsCommand;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.PlaceInstanceBreakpoint;
import de.renew.gui.ToggleBreakpointCommand;
import de.renew.gui.TransitionFigure;
import de.renew.gui.TransitionInstanceBreakpoint;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.NetLookup;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.net.event.PlaceEventProducer;
import de.renew.net.event.TransitionEventProducer;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BreakpointManager
implements SimulatorExtension {
    private static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    private static final Logger logger = Logger.getLogger(BreakpointManager.class);
    private CPNSimulation simulation;
    private CommandMenu breakpointSimulationMenu = null;
    private CommandMenu breakpointNetMenu = null;
    private final Vector<Breakpoint> breakpoints = new Vector();
    private final Vector<BreakpointHitListener> breakpointHitListeners = new Vector();
    private final Map<Breakpoint, JMenuItem> breakpointMenuItems = new HashMap<Breakpoint, JMenuItem>();
    private StringBuffer messageMemory = new StringBuffer();

    public BreakpointManager(CPNSimulation simulation) {
        this.setSimulation(simulation);
    }

    public void setSimulation(CPNSimulation sim) {
        this.simulation = sim;
    }

    public JMenu getNetMenu() {
        if (this.breakpointNetMenu == null) {
            this.breakpointNetMenu = this.createSetMenu("Breakpoint", 12);
            this.breakpointNetMenu.addSeparator();
            this.breakpointNetMenu.add((AbstractCommand)new ToggleBreakpointCommand("none", this, 2, 12), 67, MENU_SHORTCUT_KEY_MASK + 512);
        }
        return this.breakpointNetMenu;
    }

    public CPNApplication getGui() {
        return (CPNApplication)DrawPlugin.getGui();
    }

    public JMenu getSimulationMenu() {
        if (this.breakpointSimulationMenu == null) {
            CommandMenu menu = DrawApplication.createCommandMenu((String)"Breakpoints");
            menu.add((JMenuItem)this.createSetMenus("Set BP at selection"));
            menu.add((JMenuItem)this.createClearMenus("Clear BP at selection"));
            menu.add((AbstractCommand)new ClearAllBreakpointsCommand("Clear all BPs in current simulation", this, this.simulation), 67, MENU_SHORTCUT_KEY_MASK + 512);
            menu.addSeparator();
            this.breakpointSimulationMenu = menu;
        }
        return this.breakpointSimulationMenu;
    }

    protected CommandMenu createSetMenus(String title) {
        CommandMenu menu = DrawApplication.createCommandMenu((String)title);
        menu.add((JMenuItem)this.createSetMenu("local", 11));
        menu.add((JMenuItem)this.createSetMenu("global", 10));
        return menu;
    }

    protected CommandMenu createSetMenu(String title, int localGlobal) {
        CommandMenu menu = DrawApplication.createCommandMenu((String)title);
        int bpevent = 66;
        if (localGlobal == 10) {
            bpevent = 71;
        }
        menu.add((AbstractCommand)new ToggleBreakpointCommand("default (t,p)", this, 1, localGlobal), bpevent, MENU_SHORTCUT_KEY_MASK + 512);
        menu.add((AbstractCommand)new ToggleBreakpointCommand("firing starts (t)", this, 1, localGlobal, 1));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("firing completes (t)", this, 1, localGlobal, 2));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("marking changes (p)", this, 1, localGlobal, 3));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("marking changes, ignoring test arcs (p)", this, 1, localGlobal, 5));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("+ 1 token (p)", this, 1, localGlobal, 6));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("- 1 token (p)", this, 1, localGlobal, 7));
        menu.add((AbstractCommand)new ToggleBreakpointCommand("test status changes (p)", this, 1, localGlobal, 8));
        return menu;
    }

    protected CommandMenu createClearMenus(String title) {
        CommandMenu menu = DrawApplication.createCommandMenu((String)title);
        menu.add((JMenuItem)this.createClearMenu("local", 11));
        menu.add((JMenuItem)this.createClearMenu("global", 10));
        return menu;
    }

    protected CommandMenu createClearMenu(String title, int localGlobal) {
        CommandMenu menu = DrawApplication.createCommandMenu((String)title);
        menu.add((JMenuItem)new CommandMenuItem((AbstractCommand)new ToggleBreakpointCommand("any type", this, 2, localGlobal)));
        return menu;
    }

    protected CommandMenu createBPMenu(Breakpoint bp) {
        CommandMenu menu = DrawApplication.createCommandMenu((String)bp.toString());
        menu.add(MenuApi.createMenuItem((String)"show", () -> this.showBreakpoint(bp)));
        menu.add(MenuApi.createMenuItem((String)"clear", () -> this.deleteBreakpoint(bp)));
        return menu;
    }

    public Breakpoint createTransitionInstanceBreakpoint(TransitionInstance instance, int mode) {
        return this.createTransitionListenerBreakpoint((TransitionEventProducer)instance, mode, instance.getNetInstance().getNet());
    }

    public Breakpoint createTransitionBreakpoint(Transition transition, int mode, Net net) {
        return this.createTransitionListenerBreakpoint((TransitionEventProducer)transition, mode, net);
    }

    private Breakpoint createTransitionListenerBreakpoint(TransitionEventProducer producer, int mode, Net net) {
        if (!BreakpointManager.isValidTransitionMode(mode)) {
            return null;
        }
        TransitionInstanceBreakpoint newBreakpoint = new TransitionInstanceBreakpoint(this, producer, mode, net);
        this.addBreakpoint(newBreakpoint);
        return newBreakpoint;
    }

    public Breakpoint createPlaceInstanceBreakpoint(PlaceInstance instance, int mode) {
        return this.createPlaceListenerBreakpoint((PlaceEventProducer)instance, mode, instance.getNetInstance().getNet());
    }

    public Breakpoint createPlaceBreakpoint(Place place, int mode, Net net) {
        return this.createPlaceListenerBreakpoint((PlaceEventProducer)place, mode, net);
    }

    private Breakpoint createPlaceListenerBreakpoint(PlaceEventProducer producer, int mode, Net net) {
        if (!BreakpointManager.isValidPlaceMode(mode)) {
            return null;
        }
        PlaceInstanceBreakpoint newBreakpoint = new PlaceInstanceBreakpoint(this, producer, mode, net);
        this.addBreakpoint(newBreakpoint);
        return newBreakpoint;
    }

    public List<Breakpoint> getBreakpointsAt(Object netElement) {
        ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
        for (Breakpoint bp : this.breakpoints) {
            if (bp.getTaggedElement() != netElement) continue;
            result.add(bp);
        }
        return result;
    }

    public boolean isBreakpointSetAt(Object netElement) {
        for (Breakpoint bp : this.breakpoints) {
            if (bp.getTaggedElement() != netElement) continue;
            return true;
        }
        return false;
    }

    public int deleteBreakpointsAt(Object netElement) {
        List<Breakpoint> points = this.getBreakpointsAt(netElement);
        for (Breakpoint bp : points) {
            this.deleteBreakpoint(bp);
        }
        return points.size();
    }

    public void deleteAllBreakpoints() {
        int size;
        while ((size = this.breakpoints.size()) > 0) {
            this.deleteBreakpoint(this.breakpoints.get(size - 1));
        }
    }

    public void deleteBreakpoint(Breakpoint bp) {
        bp.release();
        this.removeBreakpoint(bp);
    }

    protected void addPresetBreakpoints(ShadowCompilationResult result) {
        CPNDrawingLoader drawingLoader = ModeReplacement.getInstance().getDrawingLoader();
        for (String currentNetName : result.allNewlyCompiledNetNames()) {
            Net currentNet;
            try {
                currentNet = new NetLookup().findForName(currentNetName);
            }
            catch (NetNotFoundException e) {
                logger.error((Object)("Could not find net: " + currentNetName));
                return;
            }
            CPNDrawing currentDrawing = drawingLoader.getDrawing(currentNetName, false);
            if (currentDrawing == null) {
                logger.debug((Object)("BreakpointManager: Could not add preset breakpoints for net " + currentNetName + ": no drawing found."));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(BreakpointManager.class.getName() + ": Looking for breakpoints in " + currentNetName));
            }
            FigureEnumeration figures = currentDrawing.figures();
            while (figures.hasMoreElements()) {
                Breakpoint bp;
                int id;
                Figure currentFigure = figures.nextFigure();
                Integer currentMode = (Integer)currentFigure.getAttribute("BreakpointMode");
                if (currentMode == null) continue;
                if (currentFigure instanceof TransitionFigure) {
                    TransitionFigure currentTransFig = (TransitionFigure)currentFigure;
                    id = currentTransFig.getID();
                    Transition currentTransition = currentNet.getTransitionWithID(new NetElementID(id));
                    if (currentTransition == null) {
                        logger.warn((Object)(BreakpointManager.class.getName() + ": Found no Transition for Breakpoint on Figure " + String.valueOf(currentTransFig)));
                        continue;
                    }
                    bp = this.createTransitionBreakpoint(currentTransition, currentMode, currentNet);
                    logger.debug((Object)("Created Breapoint: " + String.valueOf(bp)));
                    continue;
                }
                if (!(currentFigure instanceof PlaceFigure)) continue;
                PlaceFigure currentPlaceFig = (PlaceFigure)currentFigure;
                id = currentPlaceFig.getID();
                Place currentPlace = currentNet.getPlaceWithID(new NetElementID(id));
                if (currentPlace == null) {
                    logger.warn((Object)(BreakpointManager.class.getName() + ": Found no Place for Breakpoint on Figure " + String.valueOf(currentPlaceFig)));
                    continue;
                }
                bp = this.createPlaceBreakpoint(currentPlace, currentMode, currentNet);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Created Breapoint: " + String.valueOf(bp)));
            }
        }
    }

    private void addBreakpoint(Breakpoint newBreakpoint) {
        this.breakpoints.add(newBreakpoint);
        JMenuItem mi = this.breakpointSimulationMenu.add((JMenuItem)this.createBPMenu(newBreakpoint));
        this.breakpointMenuItems.put(newBreakpoint, mi);
    }

    private void removeBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
        JMenuItem mi = this.breakpointMenuItems.remove(breakpoint);
        EventQueue.invokeLater(() -> this.breakpointSimulationMenu.remove(mi));
    }

    protected void stopSimulation() {
        SimulationThreadPool.getCurrent().execute(this.simulation::simulationStop);
    }

    protected void informHitBreakpoint(Breakpoint breakpoint) {
        BreakpointHitListener[] listeners;
        BreakpointHitEvent event = new BreakpointHitEvent(breakpoint);
        for (BreakpointHitListener listener : listeners = this.breakpointHitListeners.toArray(new BreakpointHitListener[0])) {
            listener.hitBreakpoint(event);
        }
        if (!event.isConsumed()) {
            this.showHitBreakpoint(breakpoint);
        }
    }

    protected void showHitBreakpoint(Breakpoint breakpoint) {
        EventQueue.invokeLater(() -> {
            DrawPlugin.getGui().showStatus("A breakpoint was hit: " + String.valueOf(breakpoint) + ".");
            ErrorState e = this.locateBreakpoint(breakpoint, true);
            if (e != null) {
                GuiPlugin.getCurrent().processFigureException(e, true);
            }
        });
    }

    protected void showBreakpoint(Breakpoint breakpoint) {
        assert (EventQueue.isDispatchThread()) : "showBreakpoint must be called within AWT event queue.";
        DrawPlugin.getGui().showStatus("Selecting " + String.valueOf(breakpoint) + ".");
        ErrorState e = this.locateBreakpoint(breakpoint, false);
        if (e != null) {
            this.getGui().selectOffendingElements(e);
        }
    }

    public void addBreakpointHitListener(BreakpointHitListener listener) {
        this.breakpointHitListeners.add(listener);
    }

    public void removeBreakpointHitListener(BreakpointHitListener listener) {
        this.breakpointHitListeners.remove(listener);
    }

    public void clearLog() {
        this.messageMemory = new StringBuffer();
    }

    private ErrorState locateBreakpoint(Breakpoint breakpoint, boolean hit) {
        Object allMessages;
        Net net;
        int id;
        Object netElement;
        Object message = "";
        NetInstance netInstance = null;
        Object object = netElement = hit ? breakpoint.getHitElement() : breakpoint.getTaggedElement();
        if (netElement instanceof PlaceInstance) {
            PlaceInstance placeInst = (PlaceInstance)netElement;
            id = placeInst.getPlace().getID().getFigureID();
            netInstance = placeInst.getNetInstance();
            net = netInstance.getNet();
            if (hit) {
                message = "Hit " + String.valueOf(breakpoint) + ".";
            }
        } else if (netElement instanceof TransitionInstance) {
            TransitionInstance transitionInst = (TransitionInstance)netElement;
            id = transitionInst.getTransition().getID().getFigureID();
            netInstance = transitionInst.getNetInstance();
            net = netInstance.getNet();
            if (hit) {
                message = "Hit " + String.valueOf(breakpoint) + ".";
            }
        } else if (netElement instanceof Transition) {
            Transition transition = (Transition)netElement;
            id = transition.getID().getFigureID();
            net = breakpoint.getTaggedNet();
        } else if (netElement instanceof Place) {
            Place place = (Place)netElement;
            id = place.getID().getFigureID();
            net = breakpoint.getTaggedNet();
        } else {
            logger.error((Object)("Cannot determine the location of breakpoint at " + String.valueOf(netElement) + "!?"));
            return null;
        }
        if (hit) {
            allMessages = this.messageMemory.toString() + "\n" + (String)message;
            this.messageMemory.append("(");
            this.messageMemory.append((String)message);
            this.messageMemory.append(")\n");
        } else {
            allMessages = message;
        }
        String netName = net.getName();
        CPNDrawing drawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netName);
        if (drawing == null) {
            message = (String)message + "\nSorry, cannot show the location of breakpoint at " + String.valueOf(netElement) + " because net " + netName + " is not loaded.";
            this.getGui().showStatus((String)message);
            logger.error(message);
            return null;
        }
        if (netInstance == null) {
            FigureWithID figure = drawing.getFigureWithID(id);
            return ErrorApi.createErrorState((String)"Renew: Breakpoint", (String)allMessages, (Drawing)drawing, (Figure)figure);
        }
        try {
            if (RemotePlugin.getInstance() != null) {
                NetInstanceAccessor instanceAcc = RemotePlugin.getInstance().wrapInstance(netInstance);
                this.getGui().openInstanceDrawing(instanceAcc);
                InstanceDrawing instanceDrawing = CPNInstanceDrawing.getInstanceDrawing(instanceAcc);
                FigureWithID figure = drawing.getFigureWithID(id);
                InstanceFigure instanceFigure = instanceDrawing.getInstanceFigure((Figure)figure);
                return ErrorApi.createErrorState((String)"Renew: Breakpoint", (String)allMessages, (Drawing)instanceDrawing, (Figure)instanceFigure);
            }
            return null;
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void simulationSetup(SimulationEnvironment env) {
    }

    public void netsCompiled(ShadowCompilationResult result) {
        if (result.containsNewlyCompiledNets()) {
            this.addPresetBreakpoints(result);
        }
        this.clearLog();
    }

    public void simulationTerminated() {
        this.deleteAllBreakpoints();
        this.clearLog();
    }

    public void simulationTerminating() {
    }

    public static boolean isValidTransitionMode(int mode) {
        return mode == 1 || mode == 2 || mode == 0;
    }

    public static boolean isValidPlaceMode(int mode) {
        return mode == 3 || mode == 5 || mode == 6 || mode == 7 || mode == 8 || mode == 0;
    }
}

