/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.FigureFilter;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.ArcConnection;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SplitCommand
extends UndoableCommand {
    public SplitCommand(String name) {
        super(name);
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            Drawing drawing = EditorApi.getCurrentDrawing();
            DrawingView view = this.getEditor().view();
            NodeFigure origNode = (NodeFigure)view.selectionElements().nextElement();
            Point origNcenter = origNode.center();
            FigureEnumeration attachedArcs = StorableApi.createFilteredFigureEnumerator((FigureEnumeration)drawing.figures(), new AttachedArcFilter(origNode)::isAcceptedFigure);
            ArrayList<Figure> attachedArcBuffer = new ArrayList<Figure>();
            while (attachedArcs.hasMoreElements()) {
                attachedArcBuffer.add((Figure)attachedArcs.nextElement());
            }
            NodeFigure middleNode = this.createComplementaryNode(origNode, view);
            NodeFigure endNode = this.createComplementaryNode(middleNode, view);
            Point endNcenter = endNode.center();
            Connector endNconnector = endNode.connectorAt(endNcenter);
            AveragePointCalculator inAverage = new AveragePointCalculator();
            AveragePointCalculator outAverage = new AveragePointCalculator();
            block5: for (Figure figure : attachedArcBuffer) {
                Point otherNcenter;
                ArcConnection anArc = (ArcConnection)figure;
                switch (anArc.getArcType()) {
                    case 2: {
                        NodeFigure otherNode;
                        if (origNode.equals(anArc.startFigure())) {
                            anArc.setAttribute("ArrowMode", 1);
                            otherNode = (NodeFigure)anArc.endFigure();
                        } else {
                            anArc.setAttribute("ArrowMode", 2);
                            otherNode = (NodeFigure)anArc.startFigure();
                        }
                        ArcConnection secondArc = this.createArcFromTo(endNode, otherNode, view);
                        this.cloneChildren(anArc, secondArc, view);
                        otherNcenter = otherNode.center();
                        inAverage.add(otherNcenter);
                        outAverage.add(otherNcenter);
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        if (origNode.equals(anArc.startFigure()) && !anArc.isReverse()) {
                            anArc.disconnectStart();
                            anArc.connectStart(endNconnector);
                            anArc.updateConnection();
                            otherNcenter = anArc.endFigure().center();
                            outAverage.add(otherNcenter);
                            continue block5;
                        }
                        if (origNode.equals(anArc.endFigure()) && anArc.isReverse()) {
                            anArc.disconnectEnd();
                            anArc.connectEnd(endNconnector);
                            anArc.updateConnection();
                            otherNcenter = anArc.startFigure().center();
                            outAverage.add(otherNcenter);
                            continue block5;
                        }
                        otherNcenter = origNode.equals(anArc.startFigure()) ? anArc.endFigure().center() : anArc.startFigure().center();
                        inAverage.add(otherNcenter);
                        continue block5;
                    }
                }
                otherNcenter = origNode.equals(anArc.startFigure()) ? anArc.endFigure().center() : anArc.startFigure().center();
                inAverage.add(otherNcenter);
            }
            this.createArcFromTo(origNode, middleNode, view);
            this.createArcFromTo(middleNode, endNode, view);
            Point inCenter = inAverage.average();
            Point outCenter = outAverage.average();
            if (inCenter == null) {
                inCenter = origNcenter;
                if (outCenter != null) {
                    inCenter = new Point(2 * origNcenter.x - outCenter.x, 2 * origNcenter.y - outCenter.y);
                }
            }
            if (outCenter == null) {
                outCenter = origNcenter;
                if (inCenter != null) {
                    outCenter = new Point(2 * origNcenter.x - inCenter.x, 2 * origNcenter.y - inCenter.y);
                }
            }
            if (inCenter != null) {
                int distX = (outCenter.x - inCenter.x) / 4;
                int distY = (outCenter.y - inCenter.y) / 4;
                if (Math.abs(distX) >= 3 || Math.abs(distY) >= 3) {
                    this.centerDisplayBoxAround(inCenter.x + distX, inCenter.y + distY, origNode);
                    this.centerDisplayBoxAround(inCenter.x + 2 * distX, inCenter.y + 2 * distY, middleNode);
                    this.centerDisplayBoxAround(inCenter.x + 3 * distX, inCenter.y + 3 * distY, endNode);
                }
            }
            view.checkDamage();
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView view = this.getEditor().view();
        if (view.selectionCount() == 1) {
            Figure figure = (Figure)view.selectionElements().nextElement();
            return figure instanceof TransitionFigure || figure instanceof PlaceFigure;
        }
        return false;
    }

    private void cloneChildren(ParentFigure source, ParentFigure destination, DrawingView view) {
        FigureEnumeration childrenEnum = source.children();
        while (childrenEnum.hasMoreElements()) {
            ChildFigure child = (ChildFigure)childrenEnum.nextFigure().clone();
            child.setParent(destination);
            view.add((Figure)child);
        }
    }

    private void centerDisplayBoxAround(int x, int y, Figure fig) {
        Rectangle oldBox = fig.displayBox();
        fig.displayBox(new Point(x - oldBox.width / 2, y - oldBox.height / 2), new Point(x - oldBox.width / 2 + oldBox.width, y - oldBox.height / 2 + oldBox.height));
    }

    private NodeFigure createComplementaryNode(NodeFigure aNode, DrawingView view) {
        Dimension dim;
        FigureWithHighlight newNode;
        if (aNode instanceof TransitionFigure) {
            newNode = new PlaceFigure();
            dim = PlaceFigure.defaultDimension();
        } else {
            newNode = new TransitionFigure();
            dim = TransitionFigure.defaultDimension();
        }
        Rectangle oldBox = aNode.displayBox();
        Point oldCorner = new Point(oldBox.x + oldBox.width, oldBox.y + oldBox.height);
        newNode.displayBox(oldCorner, new Point(oldCorner.x + dim.width, oldCorner.y + dim.height));
        view.add((Figure)newNode);
        return newNode;
    }

    private ArcConnection createArcFromTo(NodeFigure from, NodeFigure to, DrawingView view) {
        ArcConnection newArc = new ArcConnection(1);
        Point fromCenter = from.center();
        Point toCenter = to.center();
        newArc.startPoint(fromCenter);
        newArc.endPoint(toCenter);
        view.add((Figure)newArc);
        newArc.connectStart(from.connectorAt(fromCenter));
        newArc.connectEnd(to.connectorAt(toCenter));
        newArc.updateConnection();
        return newArc;
    }

    static class AttachedArcFilter
    implements FigureFilter {
        final NodeFigure origNode;

        public AttachedArcFilter(NodeFigure origNode) {
            this.origNode = origNode;
        }

        public boolean isAcceptedFigure(Figure figure) {
            ArcConnection arc;
            return figure instanceof ArcConnection && ((arc = (ArcConnection)figure).startFigure().equals(this.origNode) || arc.endFigure().equals(this.origNode));
        }
    }

    static class AveragePointCalculator {
        int xSum = 0;
        int ySum = 0;
        int count = 0;

        AveragePointCalculator() {
        }

        public void add(Point p) {
            this.xSum += p.x;
            this.ySum += p.y;
            ++this.count;
        }

        public Point average() {
            if (this.count == 0) {
                return null;
            }
            return new Point(this.xSum / this.count, this.ySum / this.count);
        }
    }
}

