/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.TransitionFigure;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class VirtualTransitionFigure
extends TransitionFigure {
    private TransitionFigure transition = null;

    public VirtualTransitionFigure() {
    }

    public VirtualTransitionFigure(TransitionFigure transition) {
        this.setTransition(transition);
    }

    private void setTransition(TransitionFigure transition) {
        this.transition = (TransitionFigure)transition.getSemanticFigure();
        this.adapt();
        final FigureChangeEvent removeEvent = StorableApi.createFigureChangeEvent((Figure)this, null);
        transition.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

            public void figureChanged(FigureChangeEvent e) {
                VirtualTransitionFigure.this.adapt();
            }

            public void figureRemoved(FigureChangeEvent e) {
                if (VirtualTransitionFigure.this.listener() != null) {
                    VirtualTransitionFigure.this.listener().figureRequestRemove(removeEvent);
                }
            }
        });
    }

    @Override
    public TransitionFigure getSemanticFigure() {
        return (TransitionFigure)this.transition.getSemanticFigure();
    }

    private void adapt() {
        super.setAttribute("FillColor", (Object)this.transition.getFillColor());
        super.setAttribute("FrameColor", (Object)this.transition.getFrameColor());
    }

    public void drawFrame(Graphics g) {
        super.drawFrame(g);
        Rectangle r = this.displayBox();
        Rectangle2D.Float s = new Rectangle2D.Float(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
        ((Graphics2D)g).draw(s);
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        return null;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.transition.getShadow();
    }

    public void setAttribute(String attr, Object value) {
        if ("FillColor".equals(attr) || "FrameColor".equals(attr)) {
            this.transition.setAttribute(attr, value);
        } else {
            super.setAttribute(attr, value);
        }
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            return super.inspect(view, true);
        }
        view.clearSelection();
        view.addToSelection((Figure)this.transition);
        return true;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<TransitionFigure> myDep = new Vector<TransitionFigure>(1);
        myDep.addElement(this.transition);
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.transition);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setTransition((TransitionFigure)dr.readStorable());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setTransition(this.transition);
    }
}

