/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.application.SimulatorPlugin;
import de.renew.draw.ui.api.MenuApi;
import de.renew.gui.CPNApplication;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.GuiPlugin;
import de.renew.gui.configure.ConfigureSimulationDialog;
import de.renew.plugin.PluginManager;
import de.renew.simulator.api.SimulationManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ConfigureSimulationController {
    private static final Logger logger = Logger.getLogger(ConfigureSimulationController.class);
    private final ConfigureSimulationDialog dialog;
    private final ConfigureSimulationTabController[] tabControllers = GuiPlugin.getCurrent().getConfigTabController();

    public ConfigureSimulationController(CPNApplication app) {
        Component[] initialTabs = new Component[this.tabControllers.length];
        for (int i = 0; i < this.tabControllers.length; ++i) {
            initialTabs[i] = this.tabControllers[i].getTab();
        }
        this.dialog = new ConfigureSimulationDialog(app.getFrame(), initialTabs);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConfigureSimulationController.this.closeDialog();
            }
        });
        this.dialog.addCloseActionListener(evt -> this.closeDialog());
        this.dialog.addOkActionListener(evt -> {
            this.commitDialog();
            this.closeDialog();
        });
        this.dialog.addUpdateSimulationActionListener(evt -> this.updateDialogFromSimulation());
        this.dialog.addUpdateActionListener(evt -> this.updateDialog());
        this.dialog.addApplyActionListener(evt -> this.commitDialog());
    }

    public void showDialog() {
        if (!this.dialog.isVisible()) {
            this.updateDialog();
            this.dialog.setVisible(true);
            MenuApi.registerWindowsMenuDialog((String)MenuApi.getWindowsCategoryNameTools(), (Dialog)this.dialog);
        }
    }

    public void closeDialog() {
        MenuApi.unregisterWindowsMenuDialog((Dialog)this.dialog);
        this.dialog.setVisible(false);
    }

    public void commitDialog() {
        Properties props = ConfigureSimulationController.getSimulatorPluginProperties();
        for (ConfigureSimulationTabController tabController : this.tabControllers) {
            tabController.commitTab(props);
        }
    }

    public void updateDialog() {
        Properties props = ConfigureSimulationController.getSimulatorPluginProperties();
        for (ConfigureSimulationTabController tabController : this.tabControllers) {
            tabController.updateTab(props);
        }
    }

    public void updateDialogFromSimulation() {
        Properties props = ConfigureSimulationController.getSimulationProperties();
        if (props != null) {
            for (ConfigureSimulationTabController tabController : this.tabControllers) {
                tabController.updateTab(props);
            }
        } else {
            JOptionPane.showMessageDialog(this.dialog, "Could not update properties from current simulation:\nNo simulation running.", "Configure Simulation", 0);
        }
    }

    private static Properties getSimulatorPluginProperties() {
        logger.debug((Object)"ConfigureSimulationController: Reading the simulator plugin's properties.");
        return ConfigureSimulationController.getSimulatorPlugin().getProperties();
    }

    private static Properties getSimulationProperties() {
        Properties props = SimulationManager.getSimulationProperties();
        if (props != null) {
            logger.debug((Object)"ConfigureSimulationController: Read the current simulation's properties.");
        } else {
            logger.debug((Object)"ConfigureSimulationController: No current simulation available to read properties.");
        }
        return props;
    }

    private static SimulatorPlugin getSimulatorPlugin() {
        return (SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
    }
}

