/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.nin.PTCNetInformation;
import de.renew.gui.nin.PTCTransitionBuilder;
import java.util.Enumeration;
import java.util.HashSet;

public class PTCUnfolder {
    PTCTransitionBuilder ptcTransitionBuilder;
    PTCNetInformation ptcNetInformation;

    public CPNDrawing unfold(Enumeration<Drawing> drawings, boolean allowUplinkToUplinkSynchronization) {
        CPNDrawing combinedDrawing;
        try {
            combinedDrawing = (CPNDrawing)StorableApi.cloneStorable((Storable)drawings.nextElement());
            while (drawings.hasMoreElements()) {
                Drawing drawing = (Drawing)StorableApi.cloneStorable((Storable)drawings.nextElement());
                combinedDrawing.add(drawing);
                int xMover = this.rightmostFigureInDrawing(combinedDrawing);
                FigureEnumeration figures = drawing.figures();
                while (figures.hasMoreElements()) {
                    Figure fig = figures.nextFigure();
                    if (fig instanceof PlaceFigure || fig instanceof TransitionFigure) {
                        fig.moveBy(xMover, 0);
                    }
                    combinedDrawing.add(fig);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.unfold(combinedDrawing, allowUplinkToUplinkSynchronization);
    }

    public CPNDrawing unfold(CPNDrawing ptc_netdrawing, boolean allowUplinkToUplinkSynchronization) {
        CPNDrawing unfoldedDrawing;
        if (!this.isValidInput(ptc_netdrawing)) {
            return ptc_netdrawing;
        }
        try {
            unfoldedDrawing = (CPNDrawing)StorableApi.cloneStorable((Storable)ptc_netdrawing);
            unfoldedDrawing.setName("unfolded" + unfoldedDrawing.getName());
        }
        catch (Exception e) {
            return ptc_netdrawing;
        }
        this.ptcNetInformation = new PTCNetInformation(unfoldedDrawing);
        this.ptcTransitionBuilder = new PTCTransitionBuilder(unfoldedDrawing, this.ptcNetInformation);
        if (!allowUplinkToUplinkSynchronization) {
            for (TransitionFigure uplinkTransition : this.ptcNetInformation.getInitialUplinkTransitions().keySet()) {
                for (TransitionFigure downlinkTransition : this.ptcNetInformation.getInitialDownlinkTransitions().keySet()) {
                    if (!this.ptcNetInformation.getInitialDownlinkTransitions().get(downlinkTransition).equals(this.ptcNetInformation.getInitialUplinkTransitions().get(uplinkTransition))) continue;
                    this.ptcTransitionBuilder.buildTransitionIfBindingIsPossible(uplinkTransition, downlinkTransition);
                }
            }
        } else {
            HashSet<TransitionFigure> alreadyConsideredUplinks = new HashSet<TransitionFigure>();
            for (TransitionFigure uplinkTransition : this.ptcNetInformation.getInitialUplinkTransitions().keySet()) {
                alreadyConsideredUplinks.add(uplinkTransition);
                for (TransitionFigure partnerUplinkTransition : this.ptcNetInformation.getInitialUplinkTransitions().keySet()) {
                    if (alreadyConsideredUplinks.contains(partnerUplinkTransition) || !this.ptcNetInformation.getInitialUplinkTransitions().get(partnerUplinkTransition).equals(this.ptcNetInformation.getInitialUplinkTransitions().get(uplinkTransition))) continue;
                    this.ptcTransitionBuilder.buildTransitionIfBindingIsPossible(uplinkTransition, partnerUplinkTransition);
                }
            }
        }
        this.removeUnfoldedTransitions(unfoldedDrawing);
        return unfoldedDrawing;
    }

    private boolean isValidInput(Drawing ptc_netdrawing) {
        return ptc_netdrawing instanceof CPNDrawing;
    }

    private int rightmostFigureInDrawing(CPNDrawing drawing) {
        FigureEnumeration figures = drawing.figures();
        int rightmostPosition = 0;
        while (figures.hasMoreElements()) {
            Figure fig = figures.nextFigure();
            int xPositionOfFigure = fig.displayBox().x;
            if (xPositionOfFigure <= rightmostPosition) continue;
            rightmostPosition = xPositionOfFigure;
        }
        return rightmostPosition;
    }

    private void removeUnfoldedTransitions(Drawing unfoldedDrawing) {
        for (TransitionFigure uplinkTransition : this.ptcNetInformation.getInitialUplinkTransitions().keySet()) {
            unfoldedDrawing.remove((Figure)uplinkTransition);
        }
        for (TransitionFigure downlinkTransition : this.ptcNetInformation.getInitialDownlinkTransitions().keySet()) {
            unfoldedDrawing.remove((Figure)downlinkTransition);
        }
    }
}

