/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.pnml.parser.NetParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PNMLParser {
    private static final Logger logger = Logger.getLogger(PNMLParser.class);
    private static PNMLParser _instance;

    public static PNMLParser instance() {
        if (_instance == null) {
            _instance = new PNMLParser();
        }
        return _instance;
    }

    private PNMLParser() {
    }

    public List<Drawing> parse(InputStream pnmlStream) {
        ArrayList<Object> list = new ArrayList<Drawing>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(pnmlStream);
            NodeList nets = doc.getElementsByTagName("net");
            list = new ArrayList();
            for (int pos = 0; pos < nets.getLength(); ++pos) {
                Element net = (Element)nets.item(pos);
                NetParser netParser = new NetParser(net);
                netParser.parse();
                list.add(netParser.getNet());
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

