/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class FileFinder {
    protected static final Logger logger = Logger.getLogger(FileFinder.class);

    public static ArrayList<URI> searchPluginLocations(String extension) {
        String pluginlocation = PluginProperties.getUserProperties().getProperty("pluginLocations");
        String[] locations = pluginlocation.split(File.pathSeparator);
        ArrayList<URI> fileList = new ArrayList<URI>();
        for (String location : locations) {
            File tmp = new File(location);
            if (!tmp.exists()) {
                logger.warn((Object)("\n\n\t ===> The specified plugin location [" + location + "] does not exist! (maybe specified with .renew.properties or start.sh or ...)\n\n"));
                continue;
            }
            ArrayList<URI> searchResult = FileFinder.searchLocation(tmp, "." + extension);
            logger.debug((Object)("Search result for location " + location + ": " + String.valueOf(searchResult)));
            fileList.addAll(searchResult);
        }
        return fileList;
    }

    public static ArrayList<URI> searchLocation(File searchPath, String extension) {
        ArrayList<URI> fileList = new ArrayList<URI>();
        for (File entry : Objects.requireNonNull(searchPath.listFiles())) {
            if (entry.isDirectory()) {
                fileList.addAll(FileFinder.searchLocation(entry, extension));
                continue;
            }
            if (entry.getName().endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(entry);
                    Enumeration<JarEntry> en = jar.entries();
                    while (en.hasMoreElements()) {
                        JarEntry jarEntry = en.nextElement();
                        if (!jarEntry.getName().endsWith(extension)) continue;
                        URI jarURI = URI.create("jar:" + String.valueOf(entry.toURI()) + "!/" + String.valueOf(jarEntry));
                        fileList.add(jarURI);
                    }
                    jar.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Cannot open JAR File: " + String.valueOf(entry)));
                    logger.debug((Object)e);
                }
                continue;
            }
            if (!entry.getName().endsWith(extension)) continue;
            fileList.add(entry.toURI());
        }
        return fileList;
    }

    public static URI searchFile(String filename) {
        String fileExtension = filename.substring(filename.lastIndexOf(".") + 1);
        ArrayList<URI> fileList = FileFinder.searchPluginLocations(fileExtension);
        for (URI uri : fileList) {
            if (!uri.toString().endsWith(filename)) continue;
            return uri;
        }
        return null;
    }
}

