/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.Value;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerRangeSet
extends AbstractSet<Value> {
    private final int _first;
    private final int _last;

    public IntegerRangeSet(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("(lower bound)" + first + " > " + last + " (upper  bound).");
        }
        this._first = first;
        this._last = last;
    }

    @Override
    public int size() {
        return this._last - this._first + 1;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v.value instanceof Integer) {
                int i = v.intValue();
                return this._first <= i && i <= this._last;
            }
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        return new Iterator<Value>(){
            private int _next;
            private boolean _hasNext;
            {
                this._next = IntegerRangeSet.this._first;
                this._hasNext = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public Value next() {
                if (!this._hasNext) {
                    throw new NoSuchElementException();
                }
                this._hasNext = this._next != IntegerRangeSet.this._last;
                return new Value(this._next++);
            }
        };
    }
}

