/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.core;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.Binding;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;
import java.util.ArrayList;
import java.util.Collection;

public class GraphFinder
implements Finder {
    private final TransitionChecker _checker;
    private final Collection<Binding> _explorableBindings = new ArrayList<Binding>();
    private final Collection<Binding> _unexplorableBindings = new ArrayList<Binding>();

    public GraphFinder(TransitionChecker checker) {
        this._checker = checker;
    }

    public void found(Searcher searcher) {
        for (Occurrence occ : searcher.getOccurrences()) {
            if (!(occ instanceof TransitionOccurrence) || this._checker.isExplorable(occ.getTransition().getTransition())) continue;
            this._unexplorableBindings.add(new Binding(searcher));
            return;
        }
        this._explorableBindings.add(new Binding(searcher));
    }

    public boolean isCompleted() {
        return false;
    }

    public Collection<Binding> explorableBindings() {
        return this._explorableBindings;
    }

    public Collection<Binding> unexplorableBindings() {
        return this._unexplorableBindings;
    }

    public static interface TransitionChecker {
        public boolean isExplorable(Transition var1);
    }
}

