/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.atomicPropositions.netPredicates;

import de.renew.momoc.parser.atomicPropositions.netPredicates.NetInstancePredicate;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.log4j.Logger;

public class MarkingPredicate
implements NetInstancePredicate {
    private static final Logger log = Logger.getLogger(MarkingPredicate.class);
    private final int _amount;
    private final String _searchString;
    private final String _place;
    private final String _operator;
    private final Predicate<Integer> _cardinalityPredicate;
    private final Predicate<String[]> _containmentPredicate;

    public MarkingPredicate(String place, int amount, String operator) {
        if (operator.equals("contains")) {
            log.warn((Object)"contains does not work with amount");
        }
        this._amount = amount;
        this._searchString = null;
        this._place = place;
        this._operator = operator;
        this._cardinalityPredicate = this.createCardinalityPredicate(operator, amount);
        this._containmentPredicate = null;
    }

    public MarkingPredicate(String place, String searchString, String operator) {
        if (!operator.equals("contains")) {
            log.warn((Object)"searchStrings work only with contains");
        }
        this._amount = -1;
        this._searchString = searchString;
        this._place = place;
        this._operator = operator;
        this._cardinalityPredicate = null;
        this._containmentPredicate = this.createContainmentPredicate(operator, searchString);
    }

    @Override
    public boolean holds(NetInstance netInstance) {
        try {
            NetElementID[] placeIDs;
            NetInstanceAccessorImpl accessor = new NetInstanceAccessorImpl(netInstance, null);
            for (NetElementID placeID : placeIDs = accessor.getNet().getPlaceIDs()) {
                PlaceInstanceAccessor placeAccessor = accessor.getPlaceInstance(placeID);
                String placeName = placeAccessor.getPlace().asString();
                if (!placeName.equals(this._place)) continue;
                MarkingAccessor marking = placeAccessor.getMarking();
                if (this._cardinalityPredicate != null) {
                    return this._cardinalityPredicate.test(marking.getFreeTokenCount());
                }
                if (this._containmentPredicate == null) continue;
                return this._containmentPredicate.test(marking.getAllTokenStrings());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String toString() {
        if (this._cardinalityPredicate != null) {
            return "m[" + this._place + "]" + this._operator + this._amount;
        }
        if (this._containmentPredicate != null) {
            return "c[" + this._place + "]" + this._operator + this._searchString;
        }
        return super.toString();
    }

    private Predicate<Integer> createCardinalityPredicate(String operator, int num) {
        switch (operator) {
            case "=": {
                return a -> a == num;
            }
            case "<": {
                return a -> a < num;
            }
            case ">": {
                return a -> a > num;
            }
            case "<=": {
                return a -> a <= num;
            }
            case ">=": {
                return a -> a >= num;
            }
        }
        return null;
    }

    private Predicate<String[]> createContainmentPredicate(String operator, String searchString) {
        switch (operator) {
            case "contains": {
                return s -> Arrays.asList(s).contains(searchString);
            }
        }
        return null;
    }
}

