/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.nodes;

import de.renew.momoc.parser.atomicPropositions.AtomicProposition;
import de.renew.momoc.parser.nodes.AbstractNode;
import org.apache.log4j.Logger;

public class CTLNode
extends AbstractNode<CTLNode> {
    private static final Logger log = Logger.getLogger(CTLNode.class);
    private final NodeTypes _nodeType;

    public CTLNode(CTLNode formula1, CTLNode formula2, NodeTypes nodeType) {
        super(formula1, formula2, null);
        if (nodeType == NodeTypes.EX || nodeType == NodeTypes.EG || nodeType == NodeTypes.NOT) {
            log.warn((Object)("Node of type " + String.valueOf((Object)nodeType) + " initialised with 2 formulas!"));
        }
        this._nodeType = nodeType;
    }

    public CTLNode(CTLNode formula1, NodeTypes nodeType) {
        super(formula1, null, null);
        if (nodeType != NodeTypes.EX && nodeType != NodeTypes.EG && nodeType != NodeTypes.NOT) {
            log.warn((Object)("Node of type " + String.valueOf((Object)nodeType) + " initialised with only one formula!"));
        }
        this._nodeType = nodeType;
    }

    public CTLNode(AtomicProposition ap) {
        super(null, null, ap);
        this._nodeType = NodeTypes.AP;
    }

    public String toString() {
        if (this.getAtomicProposition() != null) {
            return this.getAtomicProposition().toString();
        }
        String f2 = this.getFormula2() != null ? "," + ((CTLNode)this.getFormula2()).toString() : "";
        return this._nodeType.toString() + "[" + ((CTLNode)this.getFormula1()).toString() + f2 + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof CTLNode) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public NodeTypes getNodeType() {
        return this._nodeType;
    }

    public static enum NodeTypes {
        EX,
        EG,
        EU,
        NOT,
        OR,
        AND,
        AP;

    }
}

