/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.procedures;

import de.renew.momoc.core.Result;
import de.renew.momoc.elements.Graph;
import de.renew.momoc.parser.ParserManager;
import de.renew.momoc.parser.atomicPropositions.AtomicProposition;
import de.renew.momoc.parser.nodes.CTLNode;
import de.renew.momoc.parser.nodes.NodeManager;
import de.renew.momoc.parser.nodes.RegisteredNode;
import de.renew.momoc.parser.processing.CTLSimplifier;
import de.renew.momoc.procedures.Procedure;
import de.renew.momoc.procedures.StdRgProcedure;
import de.renew.momoc.util.MomocConfigurationException;
import de.renew.momoc.util.Tarjan;
import de.renew.net.Net;
import de.renew.rgbase.elements.DeadlockLoop;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.Aborter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.log4j.Logger;

public class CTLModelChecker
extends Procedure {
    private static final Logger log = Logger.getLogger(CTLModelChecker.class);
    private final NodeManager<CTLNode> _nodeManager = new NodeManager();
    private Aborter _aborter;
    private Graph _reachabilityGraph;

    @Override
    public boolean usesFormulas() {
        return true;
    }

    @Override
    public Result start(Net initialMarking, Aborter aborter, String formula) throws MomocConfigurationException {
        Collection results = this.start(initialMarking, aborter, new String[]{formula});
        if (results != null) {
            return (Result)results.get(0);
        }
        return null;
    }

    public List<Result> start(Net initialMarking, Aborter aborter, String[] formulas) throws MomocConfigurationException {
        if (formulas == null || formulas.length == 0) {
            log.info((Object)"No formulas found. Returning...");
            return null;
        }
        log.info((Object)("Found " + formulas.length + " formula(s)."));
        log.info((Object)"No reachability graph. Generating...");
        StdRgProcedure stdrgp = new StdRgProcedure();
        stdrgp.addProgressListener(this::informAboutProgress);
        Graph reachabilityGraph = stdrgp.start(initialMarking, aborter, (String)null).getReachabilityGraph();
        if (aborter.abort()) {
            return null;
        }
        LinkedList<Result> results = new LinkedList<Result>();
        LinkedList<CTLNode> formulaTrees = new LinkedList<CTLNode>();
        for (String formula : formulas) {
            CTLNode syntaxTree = this.getSyntaxTree(formula);
            if (syntaxTree == null) {
                log.error((Object)("Couldn't parse " + formula + ". Aborting."));
                return null;
            }
            log.info((Object)("Parsed " + formula));
            formulaTrees.add(syntaxTree);
        }
        List<RegisteredNode> rootNodes = this._nodeManager.registerMultipleTrees(formulaTrees);
        int rootNodesSize = rootNodes.size();
        for (int i = 0; i < rootNodesSize; ++i) {
            Result result = this.start(aborter, rootNodes.get(i), reachabilityGraph);
            if (aborter.abort()) {
                return null;
            }
            result.setSpecification(formulas[i]);
            result.setRootNode(rootNodes.get(i).getId());
            results.add(result);
        }
        return results;
    }

    public Result start(Aborter aborter, String formula, Graph reachabilityGraph) throws MomocConfigurationException {
        CTLNode tree = this.getSyntaxTree(formula);
        Result result = this.start(aborter, this._nodeManager.registerTree(tree), reachabilityGraph);
        result.setSpecification(formula);
        return result;
    }

    private Result start(Aborter aborter, RegisteredNode formulaTree, Graph reachabilityGraph) {
        this._aborter = aborter;
        LinkedList<HashSet<RegisteredNode<CTLNode>>> formulaList = this._nodeManager.convertTreeToList(formulaTree);
        Result result = new Result(reachabilityGraph);
        this._reachabilityGraph = reachabilityGraph;
        this.addDeadlockEdges();
        this.checkCTLList(formulaList);
        if (this._aborter.abort()) {
            return null;
        }
        this.removeDeadlockEdges();
        Short rootNodeId = this._nodeManager.getNodeId((CTLNode)formulaTree.getNode());
        boolean fullfillsSpecification = result.getReachabilityGraph().getStartNode().hasLabel(rootNodeId);
        result.addAdditionalResult("Normalized:", formulaTree.getNode().toString());
        result.setFulfillsSpecification(fullfillsSpecification);
        result.setReachabilityGraphOnly(false);
        result.setNodeManager(this._nodeManager);
        return result;
    }

    private void addDeadlockEdges() {
        for (Node node : this._reachabilityGraph.getNodes()) {
            if (node.getEdges().size() != 0) continue;
            node.addEdge((Edge)new DeadlockLoop(node));
            node.addPredecessor(node);
        }
    }

    private void removeDeadlockEdges() {
        for (Node node : this._reachabilityGraph.getNodes()) {
            Edge edge;
            if (node.getEdges().size() != 1 || !((edge = (Edge)node.getEdges().iterator().next()) instanceof DeadlockLoop)) continue;
            node.getEdges().remove(edge);
            node.getPredecessors().remove(node);
        }
    }

    private void checkCTLList(LinkedList<HashSet<RegisteredNode<CTLNode>>> lists) {
        for (HashSet hashSet : lists) {
            for (RegisteredNode subformula : hashSet) {
                if (this._aborter.abort()) {
                    return;
                }
                this.checkCTLNode(subformula);
            }
        }
    }

    private void checkCTLNode(RegisteredNode<CTLNode> subformula) {
        CTLNode.NodeTypes nodeType = subformula.getNode().getNodeType();
        Short id = subformula.getId();
        this.informAboutProgress(subformula);
        switch (nodeType) {
            case AP: {
                AtomicProposition ap = subformula.getNode().getAtomicProposition();
                this.labelAllNodes(id, ap::holds);
                break;
            }
            case NOT: {
                this.labelAllNodes(id, node -> !node.hasLabel(subformula.getFormula1()));
                break;
            }
            case AND: {
                this.labelAllNodes(id, node -> node.hasLabel(subformula.getFormula1()) && node.hasLabel(subformula.getFormula2()));
                break;
            }
            case OR: {
                this.labelAllNodes(id, node -> node.hasLabel(subformula.getFormula1()) || node.hasLabel(subformula.getFormula2()));
                break;
            }
            case EG: {
                this.checkEG(id, subformula.getFormula1());
                break;
            }
            case EX: {
                this.checkEX(id, subformula.getFormula1());
                break;
            }
            case EU: {
                this.checkEU(id, subformula.getFormula1(), subformula.getFormula2());
            }
        }
    }

    private void labelAllNodes(Short label, Acceptor acceptor) {
        for (Node node : this._reachabilityGraph.getNodes()) {
            if (this._aborter.abort()) {
                return;
            }
            if (!acceptor.accept(node)) continue;
            node.addLabel(label);
        }
    }

    private void checkEG(Short egLabelId, Short targetLabelId) {
        HashSet<Node> fNodes = new HashSet<Node>();
        for (Node node : this._reachabilityGraph.getNodes()) {
            if (this._aborter.abort()) {
                return;
            }
            if (!node.hasLabel(targetLabelId)) continue;
            fNodes.add(node);
        }
        Node startNode = this._reachabilityGraph.getStartNode();
        Tarjan tarjan = startNode.hasLabel(targetLabelId) ? new Tarjan(fNodes, startNode) : new Tarjan(fNodes);
        Set<Set<Node>> sccs = tarjan.getSCCs();
        ArrayDeque<Node> egQueue = new ArrayDeque<Node>();
        for (Set<Node> scc : sccs) {
            if (scc.size() == 1) {
                for (Node node : scc) {
                    if (!node.getPredecessors().contains(node)) continue;
                    node.addLabel(egLabelId);
                    egQueue.add(node);
                }
                continue;
            }
            for (Node node : scc) {
                node.addLabel(egLabelId);
                egQueue.add(node);
            }
        }
        Node current = (Node)egQueue.poll();
        while (current != null) {
            for (Node node : current.getPredecessors()) {
                if (!node.hasLabel(targetLabelId) || node.hasLabel(egLabelId)) continue;
                node.addLabel(egLabelId);
                egQueue.add(node);
            }
            current = (Node)egQueue.poll();
        }
        List<Node> path = tarjan.getCyclePath();
        for (int i = 0; i < path.size() - 1; ++i) {
            path.get(i).addLabel(Short.valueOf(-egLabelId.shortValue()));
        }
    }

    private void checkEX(Short exLabelId, Short targetLabelId) {
        for (Node node : this._reachabilityGraph.getNodes()) {
            if (this._aborter.abort()) {
                return;
            }
            if (!node.hasLabel(targetLabelId)) continue;
            for (Node predecessor : node.getPredecessors()) {
                predecessor.addLabel(exLabelId);
            }
        }
    }

    private void checkEU(Short euLabelId, Short targetLabelId1, Short targetLabelId2) {
        HashMap<Node, Long> distance = new HashMap<Node, Long>();
        ArrayDeque<Node> euQueue = new ArrayDeque<Node>();
        for (Node node : this._reachabilityGraph.getNodes()) {
            if (this._aborter.abort()) {
                return;
            }
            if (!node.hasLabel(targetLabelId2)) continue;
            euQueue.add(node);
            node.addLabel(euLabelId);
            distance.put(node, 0L);
        }
        Node current = (Node)euQueue.poll();
        while (current != null) {
            for (Node node : current.getPredecessors()) {
                if (!node.hasLabel(targetLabelId1) || node.hasLabel(euLabelId)) continue;
                node.addLabel(euLabelId);
                euQueue.add(node);
                distance.put(node, (Long)distance.get(current) + 1L);
            }
            current = (Node)euQueue.poll();
        }
        List<Node> list = this.getEUWitnessPrefix(distance);
        for (Node node : list) {
            node.addLabel(Short.valueOf(-euLabelId.shortValue()));
        }
    }

    private List<Node> getEUWitnessPrefix(Map<Node, Long> distance) {
        ArrayList<Node> prefix = new ArrayList<Node>();
        Node home = this._reachabilityGraph.getStartNode();
        if (distance.containsKey(home)) {
            prefix.add(home);
            long nodeDistance = distance.get(home);
            Node node = home;
            while (nodeDistance > 0L) {
                long lastDiscovery = nodeDistance;
                node = node.getEdges().stream().map(Edge::getTargetNode).filter(distance::containsKey).filter(f -> (Long)distance.get(f) < lastDiscovery).findFirst().orElse(null);
                nodeDistance = distance.get(node);
                prefix.add(node);
            }
        }
        return prefix;
    }

    private CTLNode getSyntaxTree(String formula) throws MomocConfigurationException {
        try {
            CTLNode ctlTree = ParserManager.normalizeCTL(ParserManager.parseCTL(formula));
            return CTLSimplifier.simplifyCTL(ctlTree);
        }
        catch (ParseCancellationException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error in Syntax", 2);
            return null;
        }
    }

    @Override
    public String checkSyntax(String formula) {
        return ParserManager.testCTL(formula);
    }

    @Override
    public JPanel additionalParameterSettings() {
        return null;
    }

    @Override
    public String toString() {
        return "CTL Model Checker";
    }

    @Override
    public String description() {
        return "The basic CTL model checking algorithm. Creates a reachability graph first and applies normalized (EG,EX & EU only) CTL model checking to it.";
    }

    @Override
    public boolean allowCustomStorageManager() {
        return false;
    }

    private static interface Acceptor {
        public boolean accept(Node var1);
    }
}

