/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.storageManagers;

import de.renew.momoc.core.BindingContainer;
import de.renew.momoc.elements.Graph;
import de.renew.momoc.elements.NetInstanceState;
import de.renew.momoc.elements.NodeImpl;
import de.renew.momoc.storageManagers.StorageManager;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.InscribedEdge;
import de.renew.rgbase.elements.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SimpleStorageManager
implements StorageManager {
    private final Node _startNode;
    private final Map<NetInstanceState, Node> _nodes = new HashMap<NetInstanceState, Node>();

    public SimpleStorageManager(NodeImpl startNode) {
        this._startNode = startNode;
        startNode.addTo(this._nodes);
    }

    @Override
    public NodeImpl addIfNonexistent(NodeImpl exploredNode, BindingContainer bindingContainer) {
        NodeImpl targetNode = (NodeImpl)bindingContainer.getResultingNode();
        Node nodeInMap = this._nodes.get(targetNode.getRootInstanceState());
        if (nodeInMap == null) {
            targetNode.addTo(this._nodes);
            targetNode.addPredecessor(exploredNode);
            exploredNode.addEdge((Edge)new InscribedEdge(bindingContainer.getName(), bindingContainer.getBinding().getDescription(), (Node)targetNode));
            return targetNode;
        }
        nodeInMap.addPredecessor((Node)exploredNode);
        exploredNode.addEdge((Edge)new InscribedEdge(bindingContainer.getName(), bindingContainer.getBinding().getDescription(), nodeInMap));
        return null;
    }

    @Override
    public Collection<NodeImpl> addMultipleIfNonexistent(NodeImpl exploredNode, Collection<BindingContainer> bindingContainers) {
        ArrayList<NodeImpl> notContainedNodes = new ArrayList<NodeImpl>();
        for (BindingContainer bindingContainer : bindingContainers) {
            NodeImpl node = this.addIfNonexistent(exploredNode, bindingContainer);
            if (node == null) continue;
            notContainedNodes.add(node);
        }
        return notContainedNodes;
    }

    @Override
    public Graph getReachabilityGraph() {
        return new Graph(this._nodes, this._startNode);
    }

    public String toString() {
        return "Default";
    }

    @Override
    public String getDiscription() {
        return "The default storage manager that uses a HashMap to ensure that no duplicates are stored.";
    }
}

