/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.util;

import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Tarjan {
    private static final Logger log = Logger.getLogger(Tarjan.class);
    private int _index = 0;
    private final Deque<Node> _deque;
    private final Map<Node, Integer> _lowLinkMap;
    private final Map<Node, Integer> _indexMap;
    private final Set<Node> _inDeque;
    private final Set<Set<Node>> _sccs;
    private final List<Node> _cycle;
    private int _maxIndexInCycle;
    private final Set<Node> _nodes;

    public Tarjan(Set<Node> nodes, Node startNode) {
        if (nodes == null) {
            log.error((Object)"Tarjan was run with a null reference as set of nodes");
        } else if (startNode != null && !nodes.contains(startNode)) {
            log.error((Object)"Tarjan was run with a startNode that is not contained in the set of nodes");
        }
        this._index = 0;
        this._deque = new ArrayDeque<Node>();
        this._lowLinkMap = new HashMap<Node, Integer>();
        this._indexMap = new HashMap<Node, Integer>();
        this._inDeque = new HashSet<Node>();
        this._sccs = new HashSet<Set<Node>>();
        this._cycle = new ArrayList<Node>();
        this._maxIndexInCycle = -1;
        this._nodes = nodes;
        if (startNode != null) {
            this.strongConnect(startNode);
        }
        for (Node v : nodes) {
            if (this._indexMap.get(v) != null) continue;
            this.strongConnect(v);
        }
        Collections.reverse(this._cycle);
    }

    public Tarjan(Set<Node> nodes) {
        this(nodes, null);
    }

    public Set<Set<Node>> getSCCs() {
        return this._sccs;
    }

    public List<Node> getCyclePath() {
        return this._cycle;
    }

    private void strongConnect(Node v) {
        this._indexMap.put(v, this._index);
        this._lowLinkMap.put(v, this._index);
        ++this._index;
        this._deque.push(v);
        this._inDeque.add(v);
        Collection edges = v.getEdges();
        HashSet<Node> successors = new HashSet<Node>();
        if (edges != null) {
            for (Edge edge : edges) {
                Node targetNode = edge.getTargetNode();
                if (targetNode == null || !this._nodes.contains(targetNode)) continue;
                successors.add(targetNode);
            }
        }
        for (Node successor : successors) {
            if (!this._indexMap.containsKey(successor)) {
                this.strongConnect(successor);
                if (!this._inDeque.contains(successor)) continue;
                this._lowLinkMap.put(v, Math.min(this._lowLinkMap.get(v), this._lowLinkMap.get(successor)));
                continue;
            }
            if (!this._inDeque.contains(successor)) continue;
            if (this._maxIndexInCycle == -1) {
                this._cycle.add(successor);
                this._maxIndexInCycle = this._indexMap.get(v);
            }
            this._lowLinkMap.put(v, Math.min(this._lowLinkMap.get(v), this._indexMap.get(successor)));
        }
        if (this._lowLinkMap.get(v).equals(this._indexMap.get(v))) {
            HashSet<Node> scc = new HashSet<Node>();
            boolean foundSelf = false;
            while (!foundSelf) {
                Node w = this._deque.pop();
                this._inDeque.remove(w);
                scc.add(w);
                if (this._indexMap.get(w) <= this._maxIndexInCycle) {
                    this._cycle.add(w);
                }
                foundSelf = w.equals(v);
            }
            this._sccs.add(scc);
        }
    }
}

