/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.simulator.Binding;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.remote.BindingAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class BindingAccessorImpl
extends UnicastRemoteObject
implements BindingAccessor {
    public static final Logger LOGGER = Logger.getLogger(BindingAccessorImpl.class);
    private SimulationEnvironment _environment;
    protected final Binding _binding;

    public BindingAccessorImpl(Binding binding, SimulationEnvironment environment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this._binding = binding;
        this._environment = environment;
    }

    @Override
    public boolean execute(final boolean asynchronous) throws RemoteException {
        final StepIdentifier stepIdentifier = this._environment.getSimulator().nextStepIdentifier();
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BindingAccessorImpl.this._binding.execute(stepIdentifier, asynchronous);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return false;
    }

    @Override
    public String getDescription() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BindingAccessorImpl.this._binding.getDescription();
            }
        });
        try {
            return (String)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }
}

