/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.plugin.PropertyHelper;
import de.renew.remote.RemotePlugin;
import de.renew.remote.Server;
import de.renew.remote.ServerImpl;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RemoteExtension
implements SimulatorExtension {
    public static final Logger LOGGER = Logger.getLogger(RemoteExtension.class);
    private SimulationEnvironment _currentEnvironment = null;
    private Server _currentServer = null;
    private String _currentServerUrl = null;
    public static final String CLASS_PROP_NAME = "de.renew.remote.serverClass";
    public static final String ENABLE_PROP_NAME = "de.renew.remote.enable";
    public static final String NAME_PROP_NAME = "de.renew.remote.publicName";
    public static final Class<?> DEFAULT_SERVER_CLASS = ServerImpl.class;

    public void simulationSetup(SimulationEnvironment env) {
        assert (this._currentEnvironment == null) : "The last simulation has not been cleaned up properly.";
        assert (this._currentServer == null) : "The last remote server has not been cleaned up properly.";
        assert (this._currentServerUrl == null) : "The last remote server has not been cleaned up properly.";
        this._currentEnvironment = env;
        Properties props = env.getProperties();
        boolean enableRemote = PropertyHelper.getBoolProperty((Properties)props, (String)ENABLE_PROP_NAME);
        if (enableRemote) {
            RemotePlugin.configureInterface();
            Class<ServerImpl> serverClass = PropertyHelper.getClassProperty((Properties)props, (String)CLASS_PROP_NAME, Server.class);
            String serverName = props.getProperty(NAME_PROP_NAME);
            if (serverClass == null) {
                serverClass = ServerImpl.class;
            }
            if (serverName == null) {
                serverName = "default";
            }
            this._currentServer = this.createServer(serverClass);
            if (this._currentServer != null) {
                props.setProperty(NAME_PROP_NAME, serverName);
                props.setProperty(CLASS_PROP_NAME, serverClass.getName());
                props.setProperty(ENABLE_PROP_NAME, "true");
                this._currentServerUrl = ServerImpl.bindServer(this._currentServer, serverName, true);
            }
        } else {
            props.remove(NAME_PROP_NAME);
            props.remove(CLASS_PROP_NAME);
            props.setProperty(ENABLE_PROP_NAME, "false");
        }
    }

    private Server createServer(Class<?> serverClass) {
        Server server = null;
        LOGGER.debug((Object)("RemoteExtension: Using server class " + serverClass.getName() + "..."));
        try {
            Constructor<?> constructor = serverClass.getConstructor(SimulationEnvironment.class);
            server = (Server)constructor.newInstance(this._currentEnvironment);
            LOGGER.debug((Object)"RemoteExtension: Created server.");
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)("RemoteExtension: Could not create remote server: " + String.valueOf(e)));
        }
        catch (SecurityException e) {
            LOGGER.error((Object)("RemoteExtension: Could not create remote server: " + String.valueOf(e)));
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("RemoteExtension: Could not create remote server: " + String.valueOf(e)));
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("RemoteExtension: Could not create remote server: " + String.valueOf(e)));
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)"RemoteExtension: Server initialisation failed: ");
            LOGGER.error((Object)e.getTargetException().getMessage(), e.getTargetException());
        }
        return server;
    }

    public void simulationTerminated() {
        if (this._currentServerUrl != null) {
            ServerImpl.unbindServer(this._currentServerUrl);
            LOGGER.debug((Object)"RemoteExtension: Server disconnected from registry.");
            this._currentServerUrl = null;
        }
        this._currentServer = null;
        this._currentEnvironment = null;
    }

    public void simulationTerminating() {
    }

    public void netsCompiled(ShadowCompilationResult result) {
    }
}

