/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.CloseAllDrawingsCommand;
import CH.ifa.draw.application.CloseDrawingCommand;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.InsertDrawingCommand;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NewDefaultDrawingCommand;
import CH.ifa.draw.application.NewDrawingCommand;
import CH.ifa.draw.application.OpenDrawingCommand;
import CH.ifa.draw.application.OpenURLCommand;
import CH.ifa.draw.application.PrintDrawingCommand;
import CH.ifa.draw.application.SaveAllDrawingsCommand;
import CH.ifa.draw.application.SaveDrawingAsCommand;
import CH.ifa.draw.application.SaveDrawingCommand;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.ImportHolderImpl;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import CH.ifa.draw.util.UpdatableCommandMenuItem;
import de.renew.draw.ui.impl.menus.internal.MenuHelper;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FileMenuCreator {
    public static final String PLUGIN_SETTINGS_MENU_PROP_NAME = "de.renew.pluginSettingsMenu";
    public static Logger logger = Logger.getLogger(FileMenuCreator.class);
    private UpdatableCommandMenuItem defaultMenuItem = null;

    public Collection<JMenuItem> createMenus(ImportHolderImpl importHolder, ExportHolderImpl exportHolder, CommandMenu recentlySavedMenu) {
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("ch.ifa.draw");
        if (this.defaultMenuItem == null) {
            this.defaultMenuItem = new UpdatableCommandMenuItem(new NewDefaultDrawingCommand(), 78);
        }
        result.add(this.defaultMenuItem);
        result.add(new CommandMenuItem(new NewDrawingCommand()));
        result.add(sepFac.createSeparator());
        result.add(new CommandMenuItem(new OpenURLCommand()));
        result.add(new CommandMenuItem(new OpenDrawingCommand(), 79));
        result.add(new CommandMenuItem(new InsertDrawingCommand()));
        result.add(new CommandMenuItem(new SaveDrawingCommand(), 83));
        result.add(new CommandMenuItem(new SaveDrawingAsCommand(), 83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        result.add(new CommandMenuItem(new SaveAllDrawingsCommand()));
        result.add(new CommandMenuItem(new CloseDrawingCommand(), 87));
        result.add(new CommandMenuItem(new CloseAllDrawingsCommand(), 87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        result.add(recentlySavedMenu);
        result.add(sepFac.createSeparator());
        result.add(importHolder.getImportMenu());
        result.add(exportHolder.getExportMenu());
        result.add(sepFac.createSeparator());
        result.add(new CommandMenuItem(new PrintDrawingCommand()));
        result.add(sepFac.createSeparator());
        result.add(MenuHelper.createMenuItem("Exit", this::exit));
        return result;
    }

    private void exit() {
        DrawApplication app = DrawPlugin.getGui();
        JFrame frame = app.getFrame();
        frame.dispatchEvent(new WindowEvent(frame, 201));
    }
}

