/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

@Deprecated(since="5.0", forRemoval=true)
class PolygonScaleHandle
extends AbstractHandle {
    private Point _origin = null;
    private Point _current = null;
    private Polygon _origPoly = null;

    public PolygonScaleHandle(PolygonFigure owner) {
        super(owner);
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this._origPoly = ((PolygonFigure)this.owner()).getPolygon();
        this._origin = this.getOrigin();
        this._current = new Point(this._origin.x, this._origin.y);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        int dx = x - anchorX;
        int dy = y - anchorY;
        boolean scale = true;
        boolean rotate = true;
        this._current = new Point(this._origin.x + dx, this._origin.y + dy);
        if (e.isControlDown()) {
            rotate = false;
        } else if (e.isShiftDown()) {
            scale = false;
        }
        ((PolygonFigure)this.owner()).scaleRotate(this._origin, this._origPoly, this._current, scale, rotate);
        view.selectionInvalidateHandles();
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        super.invokeEnd(x, y, anchorX, anchorY, view);
        this._origPoly = null;
        this._origin = null;
        this._current = null;
    }

    @Override
    public Point locate() {
        if (this._current != null) {
            return this._current;
        }
        return this.getOrigin();
    }

    Point getOrigin() {
        Point outer = ((PolygonFigure)this.owner()).outermostPoint();
        Point ctr = this.owner().center();
        double len = Geom.length(outer.x, outer.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point(outer.x - 4, outer.y + 4);
        }
        double u = 8.0 / len;
        if (u > 1.0) {
            return new Point((outer.x * 3 + ctr.x) / 4, (outer.y * 3 + ctr.y) / 4);
        }
        return new Point((int)((double)outer.x * (1.0 - u) + (double)ctr.x * u), (int)((double)outer.y * (1.0 - u) + (double)ctr.y * u));
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

