/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;

public class ArrowTip
implements LineDecoration {
    private static final long serialVersionUID = -3459171428373823638L;
    protected double fAngle;
    protected double fOuterRadius;
    protected double fInnerRadius;
    protected boolean _filled;
    private final int _arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this.fAngle = 0.4;
        this.fOuterRadius = 8.0;
        this.fInnerRadius = 8.0;
        this._filled = true;
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius, boolean filled) {
        this.fAngle = angle;
        this.fOuterRadius = outerRadius;
        this.fInnerRadius = innerRadius;
        this._filled = filled;
    }

    @Override
    public void draw(Graphics g, int x1, int y1, int x2, int y2, Color fillColor, Color lineColor) {
        Shape p = this.outline(x1, y1, x2, y2);
        if (this._filled) {
            fillColor = lineColor;
        }
        if (!ColorMap.isTransparent(fillColor)) {
            g.setColor(fillColor);
            ((Graphics2D)g).fill(p);
        }
        g.setColor(lineColor);
        ((Graphics2D)g).draw(p);
    }

    public Shape outline(int x1, int y1, int x2, int y2) {
        double dir = 1.5707963267948966 - Math.atan2(x2 - x1, y1 - y2);
        return this.outline(x1, y1, dir);
    }

    protected Shape outline(int x, int y, double direction) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(x, y);
        this.addPointRelative(shape, x, y, this.fOuterRadius, direction - this.fAngle);
        this.addPointRelative(shape, x, y, this.fInnerRadius, direction);
        this.addPointRelative(shape, x, y, this.fOuterRadius, direction + this.fAngle);
        shape.closePath();
        return shape;
    }

    public void addPointRelative(GeneralPath shape, int x, int y, double radius, double angle) {
        shape.lineTo(x + (int)(radius * Math.cos(angle)), y - (int)(radius * Math.sin(angle)));
    }

    @Override
    public void write(StorableOutput dw) {
        dw.writeDouble(this.fAngle);
        dw.writeDouble(this.fOuterRadius);
        dw.writeDouble(this.fInnerRadius);
        dw.writeBoolean(this._filled);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        if (dr.getVersion() >= 5) {
            this.fAngle = dr.readDouble();
            this.fOuterRadius = dr.readDouble();
            this.fInnerRadius = dr.readDouble();
            this._filled = dr.readBoolean();
        }
    }
}

