/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class ChopRoundRectangleConnector
extends ChopBoxConnector {
    public static final Logger LOGGER = Logger.getLogger(ChopRoundRectangleConnector.class);
    private static final long serialVersionUID = -3165091511154766610L;

    public ChopRoundRectangleConnector() {
    }

    public ChopRoundRectangleConnector(Figure owner) {
        super(owner);
    }

    protected Point[] intersectEllipseLine(double rx, double ry, double a, double b) {
        double aa = a * a * rx * rx + ry * ry;
        double bb = 2.0 * b * a * rx * rx;
        double cc = (b * b - ry * ry) * rx * rx;
        double sqrt = Math.sqrt(bb * bb - 4.0 * aa * cc);
        double x1 = (-bb + sqrt) / (2.0 * aa);
        double x2 = (-bb - sqrt) / (2.0 * aa);
        double y1 = b + a * x1;
        double y2 = b + a * x2;
        return new Point[]{new Point((int)x1, (int)y1), new Point((int)x2, (int)y2)};
    }

    @Override
    protected Point chop(Figure target, Rectangle source) {
        boolean down;
        Rectangle r = target.displayBox();
        Point from = Geom.center(source);
        Point to = Geom.center(r);
        Point targetArc = ((RoundRectangleFigure)target).getArc();
        double angle = Geom.pointToAngle(r, from) + (r.intersection(source).equals(r) ? Math.PI : 0.0);
        Point toMeet = Geom.angleToPoint(r, angle);
        int leftX = r.x + targetArc.x / 2;
        int rightX = r.x + r.width - targetArc.x / 2;
        int topY = r.y + targetArc.y / 2;
        int downY = r.y + r.height - targetArc.y / 2;
        boolean left = toMeet.x < leftX;
        boolean right = toMeet.x > rightX;
        boolean top = toMeet.y < topY;
        boolean bl = down = toMeet.y > downY;
        if ((left || right) && (top || down)) {
            int xc = left ? leftX : rightX;
            int yc = top ? topY : downY;
            double a = (double)(from.y - to.y) / (double)(from.x - to.x);
            double b = (double)(from.y - yc) - (double)(from.x - xc) * a;
            Point[] intersections = this.intersectEllipseLine((double)targetArc.x / 2.0, (double)targetArc.y / 2.0, a, b);
            Point intersection = left ^ intersections[0].x < intersections[1].x ? intersections[1] : intersections[0];
            return new Point(intersection.x + xc, intersection.y + yc);
        }
        return toMeet;
    }
}

