/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.GroupHandle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CompositeAttributeFigure
extends AttributeFigure
implements FigureChangeListener {
    public static final Logger LOGGER = Logger.getLogger(CompositeAttributeFigure.class);
    protected Vector<Figure> attached = new Vector();
    protected boolean removeWhenEmpty = true;

    public CompositeAttributeFigure() {
        this.setFillColor(ColorMap.NONE);
        this.setFrameColor(ColorMap.NONE);
    }

    @Override
    public boolean includes(Figure figure) {
        return this.getAttached().contains(figure);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        for (Figure af : this.attached) {
            af.removeFigureChangeListener(this);
        }
        for (Figure af : this.attached) {
            af.moveBy(dx, dy);
        }
        for (Figure af : this.attached) {
            af.addFigureChangeListener(this);
        }
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
    }

    @Override
    public Rectangle displayBox() {
        Enumeration<Figure> k = this.attached.elements();
        Rectangle r = new Rectangle();
        if (k.hasMoreElements()) {
            r = k.nextElement().displayBox();
        }
        while (k.hasMoreElements()) {
            r.add(k.nextElement().displayBox());
        }
        if (r == null) {
            return new Rectangle(0, 0);
        }
        return r;
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        handles.addElement(new GroupHandle(this, RelativeLocator.northWest()));
        handles.addElement(new GroupHandle(this, RelativeLocator.northEast()));
        handles.addElement(new GroupHandle(this, RelativeLocator.southWest()));
        handles.addElement(new GroupHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    protected DrawingView getView() {
        DrawApplication gui = DrawPlugin.getGui();
        if (gui == null) {
            return null;
        }
        return gui.getView(gui.drawing());
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.attached.size());
        for (Figure figure : this.attached) {
            dw.writeStorable(figure);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        if (dr.getVersion() > 9) {
            super.read(dr);
        }
        this.attached = new Vector();
        int size = dr.readInt();
        if (size != 0) {
            for (int i = 1; i <= size; ++i) {
                Figure figure = (Figure)dr.readStorable();
                this.attached.add(figure);
                figure.addFigureChangeListener(this);
            }
        }
        Enumeration<String> attributeKeys = this.getAttributeKeys();
        boolean isFillColorSet = false;
        boolean isFrameColorSet = false;
        while (attributeKeys.hasMoreElements()) {
            String string = attributeKeys.nextElement();
            if (string.equals("FillColor")) {
                isFillColorSet = true;
            }
            if (!string.equals("FrameColor")) continue;
            isFrameColorSet = true;
        }
        if (!isFillColorSet) {
            this.setFillColor(ColorMap.NONE);
        }
        if (!isFrameColorSet) {
            this.setFrameColor(ColorMap.NONE);
            this.setAttribute("LineStyle", "1 2");
        }
    }

    public Vector<Figure> getAttached() {
        return this.attached;
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            return super.inspect(view, true);
        }
        view.clearSelection();
        view.addToSelectionAll(this.attached);
        return true;
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        this.invalidate();
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.changed();
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        this.willChange();
        Figure removed = e.getFigure();
        this.attached.remove(removed);
        if (this.removeWhenEmpty && this.attached.isEmpty() && this.listener() != null) {
            this.listener().figureRequestRemove(StorableApi.createFigureChangeEvent(this));
        }
        this.changed();
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        this.willChange();
        Object object = e.getSource();
        if (object instanceof Figure) {
            Figure f = (Figure)object;
            this.attached.remove(f);
        }
        this.changed();
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
        System.out.println("NCF: figureRequestUpdate");
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Enumeration<Figure> k = this.attached.elements();
        while (k.hasMoreElements()) {
            Figure figure = k.nextElement();
            figure.addToContainer(this);
        }
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        return new MergedFigureEnumerator(super.getFiguresWithDependencies(), this.getAttachedFigures());
    }

    private FigureEnumeration getAttachedFigures() {
        return new FigureEnumerator(this.attached);
    }

    public void updateListeners() {
        FigureEnumeration figures = this.getFiguresWithDependencies();
        while (figures.hasMoreElements()) {
            Figure figure = figures.nextFigure();
            figure.addToContainer(this);
        }
    }
}

