/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.Iconkit;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    public static final Logger LOGGER = Logger.getLogger(ImageFigure.class);
    private static final long serialVersionUID = 148012030121282439L;
    private String _fileName;
    private transient Image _image;
    private Rectangle _displayBox;
    private final int _imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this._fileName = null;
        this._image = null;
        this._displayBox = null;
    }

    public ImageFigure(Image image, String fileName, Point origin) {
        if (fileName != null) {
            try {
                this._fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error((Object)("Could not find file " + fileName + ": " + String.valueOf(e)));
            }
        } else {
            this._fileName = null;
        }
        this._image = image;
        this._displayBox = new Rectangle(origin.x, origin.y, 0, 0);
        this._displayBox.width = this._image.getWidth(this);
        this._displayBox.height = this._image.getHeight(this);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this._displayBox = new Rectangle(origin);
        this._displayBox.add(corner);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._displayBox.translate(x, y);
    }

    @Override
    public void internalDraw(Graphics g) {
        if (this._image == null && this._fileName != null) {
            this._image = Iconkit.instance().getImage(this._fileName);
        }
        if (this._image != null && new File(this._fileName).exists()) {
            g.drawImage(this._image, this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height, this);
        } else {
            this.drawGhost(g);
        }
    }

    private void drawGhost(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(StorableApi.createFigureChangeEvent(this));
            }
        }
        return (flags & 0xA0) == 0;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._displayBox.x);
        dw.writeInt(this._displayBox.y);
        dw.writeInt(this._displayBox.width);
        dw.writeInt(this._displayBox.height);
        URI imageURI = new File(this._fileName).toURI();
        imageURI = StringUtil.makeRelative((URI)dw.getURI(), (URI)imageURI);
        String relativePath = imageURI.getPath();
        dw.writeString(relativePath);
        LOGGER.debug((Object)relativePath);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this._fileName = dr.readString();
        URI uri = null;
        try {
            uri = dr.getURI().resolve(this._fileName);
            this._fileName = new File(uri).getCanonicalPath();
            LOGGER.debug((Object)("Including image from location: " + this._fileName));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Problem while resolving image location: " + String.valueOf(e)));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Problem while resolving image location: " + String.valueOf(e)));
            this._fileName = uri.getPath();
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"StorableInput has no URI!");
        }
        if (!GUIProperties.noGraphics()) {
            Iconkit.instance().registerImage(this._fileName);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Iconkit.instance().registerImage(this._fileName);
        this._image = null;
    }
}

