/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TextFigure
extends AttributeFigure
implements ChildFigure,
TextHolder {
    public static final Logger logger;
    private static String _currentFontName;
    private static int _currentFontSize;
    private static int _currentFontStyle;
    private static final long serialVersionUID = 4599820785949456124L;
    public static final String ALIGN_ATTR = "TextAlignment";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int _originX = 0;
    private int _originY = 0;
    private transient boolean _sizeIsDirty = true;
    private transient int _width;
    private transient int _height;
    private transient Rectangle[] _boxes;
    private String _text;
    private String[] _lines;
    private transient Font _font = null;
    private String _attributeFontName = _currentFontName;
    private int _attributeFontSize;
    private int _attributeFontStyle = _currentFontStyle;
    private boolean _isReadOnly;
    private boolean _canBeConnected = true;
    private ParentFigure _parent = null;
    private OffsetLocator _locator = null;
    private final int _textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this("");
    }

    public TextFigure(boolean canBeConnected) {
        this("");
        this._canBeConnected = canBeConnected;
    }

    public TextFigure(String text) {
        this._attributeFontSize = _currentFontSize;
        this.setAttribute("FillColor", ColorMap.color("None"));
        this.setAttribute("FrameColor", ColorMap.color("None"));
        this.internalSetText(text);
        this._sizeIsDirty = true;
    }

    protected static FontMetrics getDefaultFontMetrics(Font font) {
        BufferedImage bi = new BufferedImage(1, 1, 3);
        Graphics g = bi.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        g.dispose();
        return fm;
    }

    public TextFigure(String text, boolean isReadOnly) {
        this(text);
        this.setReadOnly(isReadOnly);
    }

    @Override
    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this._locator != null) {
            this._locator.moveBy(x, y);
        }
        this.changed();
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._originX += x;
        this._originY += y;
    }

    @Override
    public void displayBox(Point origin, Point corner) {
        this.willChange();
        int xMovedBy = origin.x - this._originX;
        int yMovedBy = origin.y - this._originY;
        this.basicDisplayBox(origin, corner);
        if (this._locator != null) {
            this._locator.moveBy(xMovedBy, yMovedBy);
        }
        this.changed();
    }

    @Override
    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this._originX = newOrigin.x;
        this._originY = newOrigin.y;
    }

    public Point getOrigin() {
        return new Point(this._originX, this._originY);
    }

    @Override
    public Rectangle displayBox() {
        this.textExtent();
        return new Rectangle(this._originX, this._originY, this._width, this._height);
    }

    @Override
    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    protected String getLine(int lineIndex) {
        return this._lines[lineIndex];
    }

    protected int getLineAlignment(int lineIndex) {
        return this.getAlignment();
    }

    protected Font getLineFont(int lineIndex) {
        return this.getFont();
    }

    public static FontMetrics getMetrics(Font font, Graphics g) {
        if (g != null) {
            return g.getFontMetrics(font);
        }
        logger.trace((Object)"Using default font metrics because no Graphics object is at hand. ");
        return TextFigure.getDefaultFontMetrics(font);
    }

    public Rectangle getLineBox(Graphics g, int i) {
        if (this._sizeIsDirty) {
            this.getLineBoxes(g);
        }
        return this._boxes[i];
    }

    protected Dimension getLineDimension(int i, Graphics g) {
        FontMetrics metrics = TextFigure.getMetrics(this.getLineFont(i), g);
        return new Dimension(metrics.stringWidth(this.getLine(i)), metrics.getHeight());
    }

    protected Rectangle[] getLineBoxes(Graphics g) {
        if (this._sizeIsDirty) {
            int i;
            this._boxes = new Rectangle[this._lines.length];
            int oldWidth = this._width;
            this._width = 0;
            this._height = 0;
            for (i = 0; i < this._lines.length; ++i) {
                Dimension dim = this.getLineDimension(i, g);
                this._boxes[i] = new Rectangle(0, this._height, dim.width, dim.height);
                this._width = Math.max(this._width, dim.width);
                this._height += dim.height;
            }
            for (i = 0; i < this._lines.length; ++i) {
                int alignment = this.getLineAlignment(i);
                if (alignment == 0) continue;
                int dx = this._width - this._boxes[i].width;
                if (alignment == 1) {
                    dx /= 2;
                }
                this._boxes[i].translate(dx, 0);
            }
            if (oldWidth != 0) {
                switch (this.getAlignment()) {
                    case 2: {
                        this._originX = this._originX + oldWidth - this._width;
                        if (this._locator == null) break;
                        this._locator.moveBy((oldWidth - this._width) / 2, 0);
                        break;
                    }
                    case 1: {
                        this._originX += (oldWidth - this._width) / 2;
                        break;
                    }
                    default: {
                        if (this._locator == null) break;
                        this._locator.moveBy(-(oldWidth - this._width) / 2, 0);
                    }
                }
            }
            this._sizeIsDirty = false;
        }
        return this._boxes;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            Rectangle[] boxes;
            if (!ColorMap.isTransparent(this.getFrameColor())) {
                return true;
            }
            x -= this._originX;
            y -= this._originY;
            for (Rectangle box : boxes = this.getLineBoxes(null)) {
                if (!box.contains(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean readOnly() {
        return this._isReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public Font getFont() {
        if (this._font == null) {
            this._font = Fontkit.getFont(this._attributeFontName, this._attributeFontStyle, this._attributeFontSize);
        }
        return this._font;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this._font = newFont;
        this._attributeFontName = this._font.getName();
        this._attributeFontStyle = this._font.getStyle();
        this._attributeFontSize = this._font.getSize();
        this.markDirty();
        this.changed();
    }

    @Override
    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public int getAlignment() {
        return (Integer)this.getAttribute(ALIGN_ATTR);
    }

    public void setAlignment(int alignment) {
        this.setAttribute(ALIGN_ATTR, alignment);
    }

    @Override
    public Object getAttribute(String name) {
        return switch (name) {
            case "FontSize" -> this._attributeFontSize;
            case "FontStyle" -> this._attributeFontStyle;
            case "FontName" -> this._attributeFontName;
            default -> super.getAttribute(name);
        };
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("FontSize") || name.equals("FontStyle") || name.equals("FontName")) {
            this.willChange();
            if (name.equals("FontSize")) {
                this._attributeFontSize = (Integer)value;
            } else if (name.equals("FontStyle")) {
                int s = (Integer)value;
                this._attributeFontStyle = s == 0 ? 0 : (this._attributeFontStyle ^= s);
            } else {
                this._attributeFontName = (String)value;
            }
            this._font = null;
            this.markDirty();
            this.changed();
            this.markDirty();
            this.changed();
        } else {
            super.setAttribute(name, value);
            if (name.equals(ALIGN_ATTR)) {
                this.willChange();
                this.markDirty();
                this.changed();
            }
        }
    }

    @Override
    public String getText() {
        return this._text;
    }

    public String[] getLines() {
        return this._lines;
    }

    @Override
    public void setText(String newText) {
        if (!newText.equals(this._text)) {
            this.willChange();
            this.basicSetText(newText);
            this.changed();
        }
    }

    protected void basicSetText(String newText) {
        this.internalSetText(newText);
        this.markDirty();
    }

    protected void internalSetText(String newText) {
        this._text = newText;
        this._lines = TextFigure.splitTextLines(newText);
    }

    protected void internalSetTextHiddenParts(String fullText, String displayText) {
        this._text = fullText;
        this._lines = TextFigure.splitTextLines(displayText);
    }

    private static String[] splitTextLines(String text) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer lines = new StringTokenizer(text, "\n", true);
        boolean lastLineTerminated = true;
        while (lines.hasMoreElements()) {
            String line = lines.nextToken();
            if ("\n".equals(line)) {
                line = "";
                lastLineTerminated = true;
            } else if (lines.hasMoreElements()) {
                lines.nextToken();
                lastLineTerminated = true;
            } else {
                lastLineTerminated = false;
            }
            vector.addElement(line);
        }
        if (lastLineTerminated) {
            vector.addElement("");
        }
        Object[] arr = new String[vector.size()];
        vector.copyInto(arr);
        return arr;
    }

    @Override
    public boolean acceptsTyping() {
        return !this._isReadOnly;
    }

    @Override
    public void internalDraw(Graphics g) {
        Color textColor;
        super.internalDraw(g);
        Color fillColor = this.getFillColor();
        this.getLineBoxes(g);
        g.translate(this._originX, this._originY);
        if (ColorMap.isTransparent(this.getFrameColor()) && !ColorMap.isTransparent(fillColor)) {
            g.setColor(fillColor);
            for (int i = 0; i < this._lines.length; ++i) {
                g.fillRect(this._boxes[i].x, this._boxes[i].y, this._boxes[i].width, this._boxes[i].height);
            }
        }
        if (!ColorMap.isTransparent(textColor = (Color)this.getAttribute("TextColor"))) {
            g.setColor(textColor);
            for (int i = 0; i < this._lines.length; ++i) {
                this.drawLine(g, i);
            }
        }
        g.translate(-this._originX, -this._originY);
    }

    protected void drawLine(Graphics g, int i) {
        Font font = this.getLineFont(i);
        g.setFont(font);
        int x = this._boxes[i].x;
        int y = this._boxes[i].y;
        String s = this.getLine(i);
        g.drawString(s, x, y + TextFigure.getMetrics(font, g).getAscent());
        if (font instanceof ExtendedFont && ((ExtendedFont)font).isUnderlined()) {
            FontMetrics fm = g.getFontMetrics();
            LineMetrics lm = fm.getLineMetrics(s, g);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D.Float shape = new Rectangle2D.Float(x, y + (int)lm.getUnderlineOffset() + TextFigure.getMetrics(font, g).getAscent(), fm.stringWidth(s), Math.max(1, (int)lm.getUnderlineThickness()));
            g2.fill(shape);
        }
    }

    @Override
    public void drawBackground(Graphics g) {
        if (!ColorMap.isTransparent(this.getFrameColor())) {
            Rectangle r = this.displayBox();
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
            g2.fill(s);
        }
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    private Dimension textExtent() {
        this.getLineBoxes(null);
        return new Dimension(this._width, this._height);
    }

    protected void markDirty() {
        this._sizeIsDirty = true;
    }

    @Override
    public Dimension overlayRowsAndColumns() {
        String[] lines;
        int columns = 20;
        for (String line : lines = this.getLines()) {
            columns = Math.max(columns, line.length() + 3);
        }
        int rows = Math.max(1, lines.length);
        return new Dimension(columns, rows);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return handles;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._originX);
        dw.writeInt(this._originY);
        dw.writeString(this._text);
        dw.writeString(this._attributeFontName);
        dw.writeInt(this._attributeFontStyle);
        dw.writeInt(this._attributeFontSize);
        dw.writeBoolean(this._isReadOnly);
        dw.writeStorable(this._parent);
        dw.writeStorable(this._locator);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._originX = dr.readInt();
        this._originY = dr.readInt();
        String text = dr.readString();
        this.setText(text);
        this._attributeFontName = dr.readString();
        this._attributeFontStyle = dr.readInt();
        this._attributeFontSize = dr.readInt();
        if (dr.getVersion() < 8 && "Helvetica".equals(this._attributeFontName)) {
            this._attributeFontName = "SansSerif";
        }
        this._font = null;
        this._isReadOnly = dr.readBoolean();
        this._parent = (ParentFigure)dr.readStorable();
        this._locator = (OffsetLocator)dr.readStorable();
        if (this._parent != null) {
            this._parent.addChild(this);
        } else {
            this._canBeConnected = false;
        }
        if (GUIProperties.noGraphics()) {
            this._sizeIsDirty = false;
        } else {
            this.updateLocation();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this._parent != null) {
            this._parent.addChild(this);
        }
        this.markDirty();
    }

    @Override
    public boolean canBeParent(ParentFigure figure) {
        if (!this._canBeConnected) {
            return figure == null;
        }
        while (figure != null) {
            if (figure == this) {
                return false;
            }
            if (!(figure instanceof ChildFigure)) break;
            figure = ((ChildFigure)((Object)figure)).parent();
        }
        return true;
    }

    @Override
    public boolean setParent(ParentFigure figure) {
        if (!this.canBeParent(figure)) {
            return false;
        }
        if (this._parent != null) {
            this._parent.removeChild(this);
        }
        this._parent = figure;
        if (this._parent == null) {
            this._locator = null;
        } else {
            this._parent.addChild(this);
            if (this._locator != null) {
                this._locator.setBase(this._parent.connectedTextLocator(this));
            } else {
                this._locator = new OffsetLocator(this._parent.connectedTextLocator(this));
            }
            this.updateLocation();
        }
        return true;
    }

    @Override
    public ParentFigure parent() {
        return this._parent;
    }

    @Override
    public void updateLocation() {
        if (this._locator != null) {
            Point p = this._locator.locate(this._parent);
            p.x -= this.size().width / 2 + this._originX;
            p.y -= this.size().height / 2 + this._originY;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    @Override
    public void release() {
        super.release();
        if (this._parent != null) {
            this._parent.removeChild(this);
        }
    }

    public static Font createCurrentFont() {
        return Fontkit.getFont(_currentFontName, _currentFontStyle, _currentFontSize);
    }

    public static void setCurrentFontName(String name) {
        _currentFontName = name;
    }

    public static void setCurrentFontSize(int size) {
        _currentFontSize = size;
    }

    public static void setCurrentFontStyle(int style) {
        _currentFontStyle = style;
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.updateLocation();
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(StorableApi.createFigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<Figure> myDep = new Vector<Figure>(1);
        myDep.addElement(this.parent());
        return new MergedFigureEnumerator(superDep, new FigureEnumerator(myDep));
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        if (!alternate) {
            return super.inspect(view, false);
        }
        if (this.acceptsTyping()) {
            view.editor().doTextEdit(this);
            return true;
        }
        return false;
    }

    static {
        String defaultFontName;
        logger = Logger.getLogger(TextFigure.class);
        _currentFontName = "SansSerif";
        _currentFontSize = 12;
        _currentFontStyle = 0;
        int defaultFontSize = GUIProperties.defaultFontSize();
        if (defaultFontSize != -1) {
            _currentFontSize = defaultFontSize;
            logger.debug((Object)("Setting default font size to " + _currentFontSize + " pt."));
        }
        if (!(defaultFontName = GUIProperties.defaultFontName()).equals("none")) {
            _currentFontName = defaultFontName;
            logger.debug((Object)("Setting default font to " + _currentFontName + "."));
        }
    }
}

