/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.util.KnownPlugins;
import CH.ifa.draw.util.UnknownTypeException;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.ui.ontology.StatusDisplayer;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class StorableInputDrawingLoader {
    private static final Logger logger = Logger.getLogger(StorableInputDrawingLoader.class);

    protected StorableInput makeStorableInput(URL location, boolean useUFT) throws IOException {
        return StorableApi.createStorableInput(location, useUFT);
    }

    protected StorableInput makeStorableInput(InputStream stream, boolean useUFT) {
        return StorableApi.createStorableInput(stream, useUFT);
    }

    public PositionedDrawing readFromStorableInput(File file, StatusDisplayer sd) throws IOException {
        try {
            return this.readFromStorableInput(file.toURI().toURL(), sd);
        }
        catch (MalformedURLException e) {
            sd.showStatus("Error " + String.valueOf(e));
            return null;
        }
    }

    public PositionedDrawing readFromStorableInput(InputStream stream) throws FileNotFoundException, IOException {
        StorableInput input = StorableApi.createStorableInput(stream, true);
        return this.readFromStorableInput(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionedDrawing readFromStorableInput(URL location, StatusDisplayer sd) throws IOException {
        try (StorableInput input = null;){
            input = this.makeStorableInput(location, true);
            PositionedDrawing positionedDrawing = this.readFromStorableInput(input, sd);
            return positionedDrawing;
        }
    }

    private PositionedDrawing readFromStorableInput(StorableInput input, StatusDisplayer sd) {
        Drawing drawing = null;
        Point newWindowLoc = null;
        Dimension newWindowDim = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(input);
            if (input.canReadInt()) {
                newWindowLoc = new Point(input.readInt(), input.readInt());
                newWindowDim = new Dimension(input.readInt(), input.readInt());
            }
        }
        catch (FileNotFoundException fnfe) {
            sd.showStatus("Error: File not found. " + String.valueOf(fnfe));
        }
        catch (IOException ioe) {
            logger.error((Object)("Could not open Drawing: " + input.getURI().toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StorableInputDrawingLoader.class.getSimpleName() + ": " + String.valueOf(ioe)));
            }
            if (ioe instanceof UnknownTypeException) {
                UnknownTypeException ute = (UnknownTypeException)ioe;
                String missingPlugin = KnownPlugins.guessPluginByClass(ute.getType());
                StringBuilder sb = new StringBuilder();
                sb.append("Error:\n");
                sb.append("Could not open Drawing:\n");
                try {
                    sb.append(URLDecoder.decode(input.getURI().toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    sb.append(input.getURI().toString());
                }
                sb.append("\n\n");
                sb.append("There might be a plugin missing.");
                if (missingPlugin != null) {
                    sb.append("\n");
                    sb.append("Try to install the plugin: ");
                    sb.append(missingPlugin);
                }
                String message = sb.toString();
                JOptionPane.showMessageDialog(null, message, "Error: Could not open Drawing", -1);
            }
            sd.showStatus("Error: Could not open Drawing. " + String.valueOf(ioe));
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(newWindowLoc, newWindowDim, drawing);
    }

    private PositionedDrawing readFromStorableInput(StorableInput input) throws FileNotFoundException, IOException {
        Drawing drawing = null;
        Point newWindowLoc = null;
        Dimension newWindowDim = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(input);
            if (input.canReadInt()) {
                newWindowLoc = new Point(input.readInt(), input.readInt());
                newWindowDim = new Dimension(input.readInt(), input.readInt());
            }
        }
        catch (FileNotFoundException fnfe) {
            String msg = "StorableInputDrawingLoader.readFromStorableInput : Error: File not found. " + String.valueOf(fnfe);
            throw new FileNotFoundException(msg);
        }
        catch (IOException ioe) {
            String msg = "StorableInputDrawingLoader.readFromStorableInput : Error " + String.valueOf(ioe);
            throw new IOException(msg);
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(newWindowLoc, newWindowDim, drawing);
    }

    public static Drawing readStorableDrawing(StorableInput input) throws IOException {
        if (input.canReadInt()) {
            input.setVersion(input.readInt());
        } else {
            input.setVersion(0);
        }
        return (Drawing)input.readStorable();
    }
}

