/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class AbstractHandle
implements FigureHandle {
    public static final int HANDLESIZE = 8;
    private final Figure _owner;
    private boolean _didChange;

    public AbstractHandle(Figure owner) {
        this._owner = owner;
        this.noChangesMade();
    }

    @Override
    public abstract Point locate();

    public void invokeStart(int x, int y, DrawingView view) {
        view.editor().prepareUndoSnapshot();
        this.changesMade();
    }

    @Override
    public void invokeStart(MouseEvent e, int x, int y, DrawingView view) {
        this.invokeStart(x, y, view);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.invokeStep(x, y, anchorX, anchorY, view);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        if (this._didChange) {
            view.editor().commitUndoSnapshot();
        }
        this.noChangesMade();
    }

    @Override
    public void invokeEnd(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.invokeEnd(x, y, anchorX, anchorY, view);
    }

    @Override
    public void abort(DrawingView view) {
    }

    protected void noChangesMade() {
        this._didChange = false;
    }

    protected void changesMade() {
        this._didChange = true;
    }

    @Override
    public Figure owner() {
        return this._owner;
    }

    @Override
    public Rectangle displayBox() {
        Point p = this.locate();
        return new Rectangle(p.x - 4, p.y - 4, 8, 8);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

