/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.UndoableTool;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionTool
extends UndoableTool {
    private Connector _startConnector;
    private Connector _endConnector;
    private Connector _connectorTarget = null;
    private Figure _target = null;
    private ConnectionFigure _connection = null;
    private int _splitPoint;
    private ConnectionFigure _editedConnection = null;
    private final ConnectionFigure _prototype;

    public ConnectionTool(DrawingEditor editor, ConnectionFigure prototype) {
        super(editor);
        this._prototype = prototype;
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        ConnectionFigure connection = this.findConnection(x, y, this.drawing());
        if (connection != null) {
            if (!connection.joinSegments(x, y)) {
                this._splitPoint = connection.splitSegment(x, y);
                this._editedConnection = connection;
            } else {
                this._editedConnection = null;
            }
            this.changesMade();
        } else {
            this._connection = this.createConnection();
            this._target = this.findConnectionStart(x, y, this.drawing());
            if (this._target != null) {
                this._startConnector = this.findConnector(x, y, this._target);
                if (this._startConnector != null) {
                    Point p = new Point(x, y);
                    this._connection.startPoint(p.x, p.y);
                    this._connection.endPoint(p.x, p.y);
                    this.view().add(this._connection);
                    this.changesMade();
                } else {
                    this._connection = null;
                }
            } else {
                this._connection = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        Point p = new Point(x, y);
        if (this._connection != null) {
            this.trackConnectors(e, x, y);
            if (this._connectorTarget != null) {
                p = Geom.center(this._connectorTarget.displayBox());
            }
            this._connection.endPoint(p.x, p.y);
        } else if (this._editedConnection != null) {
            Point pp = new Point(x, y);
            this._editedConnection.setPointAt(pp, this._splitPoint);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        Figure c = null;
        if (this._startConnector != null) {
            c = this.findTarget(x, y, this.drawing());
        }
        if (c != null) {
            this._endConnector = this.findConnector(x, y, c);
            if (this._endConnector != null) {
                this._connection.connectStart(this._startConnector);
                this._connection.connectEnd(this._endConnector);
                this._connection.updateConnection();
            }
        } else if (this._connection != null) {
            this.view().remove(this._connection);
            this.noChangesMade();
        }
        this._connection = null;
        this._endConnector = null;
        this._startConnector = null;
        this.editor().toolDone();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this._connection != null) {
            this.view().remove(this._connection);
            this.noChangesMade();
            this._connection = null;
            this._endConnector = null;
            this._startConnector = null;
        }
        if (this._target != null) {
            this._target.connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this._prototype.clone();
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        List<Figure> possibleSources = this.findAllConnectableFigures(x, y, drawing);
        for (Figure source : possibleSources) {
            if (source == null || this._connection == null || !source.canConnect() || !this._connection.canConnectStart(source)) continue;
            return source;
        }
        return null;
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        Figure start = this._startConnector.owner();
        for (Figure target : possibleTargets) {
            if (target == null || this._connection == null || !target.canConnect() || target.includes(start) || !this._connection.canConnect(start, target)) continue;
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if (!((figure = figure.findFigureInside(x, y)) instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected ConnectionFigure createdFigure() {
        return this._connection;
    }

    protected void trackConnectors(MouseEvent e, int x, int y) {
        if (this._connection == null) {
            return;
        }
        Figure c = this._startConnector == null ? this.findSource(x, y, this.drawing()) : this.findTarget(x, y, this.drawing());
        if (c != this._target) {
            if (this._target != null) {
                this._target.connectorVisibility(false);
            }
            this._target = c;
            if (this._target != null) {
                this._target.connectorVisibility(true);
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(x, y, c);
        }
        if (cc != this._connectorTarget) {
            this._connectorTarget = cc;
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        for (Figure target : possibleTargets) {
            if (target == null || !target.canConnect() || !this._connection.canConnectStart(target)) continue;
            return target;
        }
        return null;
    }

    private List<Figure> findAllConnectableFigures(int x, int y, Drawing drawing) {
        ArrayList<Figure> connectableFigures = new ArrayList<Figure>();
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (this._connection != null && figure.includes(this._connection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            connectableFigures.add(figure);
        }
        return connectableFigures;
    }

    protected Connector getStartConnector() {
        return this._startConnector;
    }

    protected Connector getEndConnector() {
        return this._endConnector;
    }

    protected Connector getTarget() {
        return this._connectorTarget;
    }
}

