/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class FloatingTextField {
    public static final Logger LOGGER = Logger.getLogger(FloatingTextField.class);
    private Rectangle _minimum;
    protected JScrollPane scrollPane;
    protected JTextArea fEditWidget = new JTextArea(1, 10);
    private Container _container;

    public FloatingTextField() {
        this.fEditWidget.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FloatingTextField.this.updateOverlay();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FloatingTextField.this.updateOverlay();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FloatingTextField.this.updateOverlay();
            }
        });
        this.scrollPane = new JScrollPane(this.fEditWidget, 21, 31);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._minimum = null;
    }

    protected void updateOverlay() {
        SwingUtilities.invokeLater(() -> {
            Dimension d = this.fEditWidget.getPreferredSize();
            if (this._minimum != null) {
                this.scrollPane.setBounds(this._minimum.x, this._minimum.y, Math.max(d.width, this._minimum.width) + 5, Math.max(d.height, this._minimum.height) + 5);
            }
            this.scrollPane.repaint();
            this.scrollPane.validate();
        });
    }

    public void createOverlay(Container container, Rectangle minimum, Font font) {
        this._minimum = minimum;
        this._container = container;
        this._container.add((Component)this.scrollPane, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.scrollPane.setLocation(minimum.x, minimum.y);
        this.scrollPane.repaint();
        this.scrollPane.validate();
        this.scrollPane.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
        this.updateOverlay();
    }

    public void endOverlay() {
        this._container.requestFocus();
        if (this.fEditWidget == null) {
            return;
        }
        this.scrollPane.setVisible(false);
        this._container.remove(this.scrollPane);
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public void setText(String text) {
        this.fEditWidget.setText(text);
    }

    public void setCaretPosition(int line, int column) {
        int pos = FloatingTextField.position(this.fEditWidget.getText(), line, column);
        this.fEditWidget.select(pos, pos);
        this.fEditWidget.setCaretPosition(pos);
    }

    public void select(int startLine, int startColumn, int endLine, int endColumn) {
        int startPos = FloatingTextField.position(this.fEditWidget.getText(), startLine, startColumn);
        int endPos = FloatingTextField.position(this.fEditWidget.getText(), endLine, endColumn);
        this.fEditWidget.select(startPos, endPos);
    }

    private static int position(String str, int line, int col) {
        int pos = 0;
        BufferedReader read = new BufferedReader(new StringReader(str));
        while (--line > 0) {
            try {
                String oneLine = read.readLine();
                pos += oneLine.length() + 1;
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return pos + col - 1;
    }

    public void addKeyListener(KeyListener keyListener) {
        this.fEditWidget.addKeyListener(keyListener);
    }
}

