/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import de.renew.plugin.PluginManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

@Deprecated(since="5.0", forRemoval=true)
public class Iconkit {
    @Deprecated(since="5.0", forRemoval=true)
    public static final Logger LOGGER = Logger.getLogger(Iconkit.class);
    private static final int ID = 123;
    private static Iconkit _instance = null;
    private final Hashtable<String, Image> _images = new Hashtable(53);
    private final Vector<String> _registeredImages = new Vector(10);
    private final MediaTracker _tracker;

    public Iconkit(Component component) {
        this._tracker = new MediaTracker(component);
        _instance = this;
    }

    @Deprecated(since="5.0", forRemoval=true)
    public static synchronized Iconkit instance() {
        if (_instance == null) {
            return new Iconkit(new Frame());
        }
        return _instance;
    }

    @Deprecated(since="5.0", forRemoval=true)
    public void registerImage(String fileName) {
        this._registeredImages.addElement(fileName);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Image registerAndLoadImage(Component ignored, String fileName) {
        this.registerImage(fileName);
        this.loadRegisteredImages();
        return this.getImage(fileName);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Image loadImage(String filename) {
        if (this._images.containsKey(filename)) {
            return this._images.get(filename);
        }
        Image image = this.loadImageResource(filename);
        if (image != null) {
            this._images.put(filename, image);
        }
        return image;
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Image getImage(String filename) {
        if (this._images.containsKey(filename)) {
            return this._images.get(filename);
        }
        this.loadRegisteredImages();
        return this._images.get(filename);
    }

    private Image loadImageResource(String resourceName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = PluginManager.getInstance().getBottomClassLoader().getResource(resourceName);
            LOGGER.debug((Object)(resourceName + "(" + String.valueOf(url) + ")"));
            if (url == null) {
                return toolkit.getImage(resourceName);
            }
            Object content = url.getContent();
            if (content instanceof ImageProducer) {
                return toolkit.createImage((ImageProducer)content);
            }
            if (content instanceof InputStream) {
                InputStream stream = (InputStream)content;
                return this.loadImageInputStream(toolkit, stream);
            }
            return toolkit.getImage(url);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("While loading " + resourceName + ":"));
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private Image loadImageInputStream(Toolkit toolkit, InputStream stream) throws IOException {
        boolean canReadMore;
        int max = 1024;
        if (stream.available() > max) {
            max = stream.available();
        }
        byte[] data = new byte[max];
        int pos = 0;
        do {
            int num;
            if (pos > max / 2) {
                byte[] newData = new byte[max *= 2];
                System.arraycopy(data, 0, newData, 0, pos);
                data = newData;
            }
            boolean bl = canReadMore = (num = stream.read(data, pos, max - pos)) > 0;
            if (!canReadMore) continue;
            pos += num;
        } while (canReadMore);
        stream.close();
        return toolkit.createImage(data, 0, pos);
    }

    private void loadRegisteredImages() {
        if (this._registeredImages.isEmpty()) {
            return;
        }
        Enumeration<String> k = this._registeredImages.elements();
        while (k.hasMoreElements()) {
            String fileName = k.nextElement();
            if (this._images.get(fileName) != null) continue;
            this._tracker.addImage(this.loadImage(fileName), 123);
        }
        this._registeredImages.removeAllElements();
        try {
            this._tracker.waitForAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

