/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagementgui.gui;

import de.renew.propertymanagement.prop.ConfigurableHotkeyProperty;
import de.renew.propertymanagement.prop.ConfigurableProperty;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import de.renew.propertymanagementgui.gui.HotkeyField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PageComponent
extends de.renew.propertymanagementgui.reactivecomponents.Component {
    private static final Font START_TEXT_FONT = new Font("Arial", 1, 24);
    private static final String START_TEXT = "<html>Click on a plugin to see its settings.</html>";
    private static final Dimension PAGE_DIMENSION = new Dimension(200, 200);
    private static final EmptyBorder PAGE_BORDER = new EmptyBorder(10, 10, 10, 10);
    private static final Insets PROPERTY_LABEL_INSETS = new Insets(10, 0, 10, 0);
    private static final Insets PROPERTY_COMPONENT_INSETS = new Insets(0, 0, 0, 0);
    private final List<ConfigurableProperty> _properties;
    private final ConfigurablePropertyManager _propertyManager = ConfigurablePropertyManager.getInstance();
    private GridBagConstraints _constraints;
    private JComponent _page;

    public PageComponent(List<ConfigurableProperty> properties) {
        this._properties = properties;
    }

    @Override
    protected JComponent render() {
        this._page = new JPanel();
        this._page.setPreferredSize(PAGE_DIMENSION);
        this._page.setBorder(PAGE_BORDER);
        this._page.setLayout(new GridBagLayout());
        this._constraints = new GridBagConstraints();
        this._constraints.fill = 2;
        this._constraints.weightx = 1.0;
        this._constraints.gridx = 0;
        if (this._properties != null) {
            this.createPropertiesGui();
        } else {
            JLabel startText = new JLabel(START_TEXT);
            startText.setFont(START_TEXT_FONT);
            this._page.add(startText);
        }
        JScrollPane scrollPane = new JScrollPane(this._page);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    private void createPropertiesGui() {
        for (int i = 0; i < this._properties.size(); ++i) {
            ConfigurableProperty property = this._properties.get(i);
            JLabel label = this.createPropertyLabel(property);
            this._constraints.insets = PROPERTY_LABEL_INSETS;
            this._constraints.gridy = i;
            this._constraints.gridx = 0;
            this._page.add((Component)label, this._constraints);
            this._constraints.insets = PROPERTY_COMPONENT_INSETS;
            this._constraints.gridx = 1;
            if ("true".equalsIgnoreCase(property.getDefaultValue()) || "false".equalsIgnoreCase(property.getDefaultValue())) {
                JCheckBox checkBox = this.createCheckBox(property);
                this._page.add((Component)checkBox, this._constraints);
                continue;
            }
            if (property instanceof ConfigurableHotkeyProperty) {
                ConfigurableHotkeyProperty hotkeyProperty = (ConfigurableHotkeyProperty)property;
                HotkeyField hotkeyField = new HotkeyField(hotkeyProperty);
                this._page.add((Component)hotkeyField, this._constraints);
                continue;
            }
            if (property.getSelectionChoices() == null) {
                JTextField textField = this.createTextField(property);
                this._page.add((Component)textField, this._constraints);
                continue;
            }
            JComboBox<String> comboBox = this.createComboBox(property);
            this._page.add(comboBox, this._constraints);
        }
    }

    private JLabel createPropertyLabel(ConfigurableProperty property) {
        JLabel label = property.getDisplayName() != null && !property.getDisplayName().isEmpty() ? new JLabel(property.getDisplayName()) : new JLabel(property.getKey());
        return label;
    }

    private JCheckBox createCheckBox(ConfigurableProperty property) {
        JCheckBox checkBox = new JCheckBox();
        if (property.getCurrentValue() == null) {
            checkBox.setSelected(Boolean.parseBoolean(property.getDefaultValue()));
        } else {
            checkBox.setSelected(Boolean.parseBoolean(property.getCurrentValue()));
        }
        checkBox.addItemListener(e -> this._propertyManager.changeProperty(property.getKey(), String.valueOf(checkBox.isSelected())));
        return checkBox;
    }

    private JTextField createTextField(final ConfigurableProperty property) {
        final JTextField textField = property.getCurrentValue() != null ? new JTextField(property.getCurrentValue()) : new JTextField(property.getDefaultValue());
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PageComponent.this._propertyManager.changeProperty(property.getKey(), textField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PageComponent.this._propertyManager.changeProperty(property.getKey(), textField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PageComponent.this._propertyManager.changeProperty(property.getKey(), textField.getText());
            }
        });
        return textField;
    }

    private JComboBox<String> createComboBox(ConfigurableProperty property) {
        HashSet<String> optionsList = new HashSet<String>();
        optionsList.add(property.getCurrentValue());
        optionsList.add(property.getDefaultValue());
        optionsList.addAll(List.of(property.getSelectionChoices()));
        JComboBox<String> comboBox = new JComboBox<String>(optionsList.toArray(new String[0]));
        if (property.getCurrentValue() != null) {
            comboBox.setSelectedItem(property.getCurrentValue());
        } else {
            comboBox.setSelectedItem(property.getDefaultValue());
        }
        comboBox.addActionListener(e -> this._propertyManager.changeProperty(property.getKey(), (String)comboBox.getSelectedItem()));
        return comboBox;
    }
}

